import type { MetaFunction } from "@remix-run/node";
import { ProtectedRoute } from "~/components/RouteProtection";
import { useLanguage } from "~/hooks/useLanguage";

export const meta: MetaFunction = () => {
  return [
    { title: "Home - Nomadics Studios" },
    {
      name: "description",
      content:
        "Connect creators with premium studio spaces, professional equipment, and a thriving creative community.",
    },
  ];
};

export default function Home() {
  const { t } = useLanguage();

  return (
    <ProtectedRoute>
      <div className="min-h-screen flex items-center justify-center bg-black text-white">
        <div className="text-center px-4">
          <div className="mb-8">
            <img 
              src="/images/logo-white.png" 
              alt="Nomadics Studios" 
              className="h-16 lg:h-20 w-auto mx-auto mb-8"
            />
          </div>
          
          <h1 className="text-4xl lg:text-6xl font-bold mb-6 tracking-wider">
            {t("home.comingSoon", "COMING SOON")}
          </h1>
          
          <p className="text-lg lg:text-xl text-white/80 mb-8 max-w-2xl mx-auto leading-relaxed">
            {t("home.description", "We're building something amazing for creators worldwide.")} 
            <br />
            {t("home.subDescription", "Premium studio spaces, professional equipment, and a thriving creative community.")}
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <div className="text-sm text-white/60 uppercase tracking-widest">
              {t("home.stayTuned", "Stay tuned for updates")}
            </div>
          </div>
        </div>
      </div>
    </ProtectedRoute>
  );
}