import React from "react";

const servicesData = [
  {
    title: "SOCIAL MEDIA STRATEGY",
    description:
      "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality.",
    image: "https://images.unsplash.com/photo-1515378791036-0648a3ef77b2", // Replace with your image
    reverse: false,
  },
  {
    title: "CONTENT CREATION (IMAGES, VIDEOS, COPY)",
    description:
      "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality.",
    image: "https://images.unsplash.com/photo-1465101046530-73398c7f28ca", // Replace with your image
    reverse: true,
  },
  {
    title: "PAID AD CAMPAIGNS",
    description:
      "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality.",
    image: "https://images.unsplash.com/photo-1519125323398-675f0ddb6308", // Replace with your image
    reverse: false,
  },
  {
    title: "ANALYTICS AND INSIGHTS",
    description:
      "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality.",
    image: "https://images.unsplash.com/photo-1506744038136-46273834b3fb", // Replace with your image
    reverse: true,
  },
];

export default function services() {
  return (
    <div className="bg-black text-white min-h-screen font-sans">
      {/* Hero Section */}
      <section className="max-w-7xl mx-auto px-6 py-20">
        <h1 className="text-6xl md:text-7xl font-black mb-8 leading-tight">
          GROW YOUR AUDIENCE,
          <br />
          BUILD YOUR BRAND.
        </h1>
        <div className="flex flex-col md:flex-row md:items-center gap-8 mb-16">
          <div className="md:w-1/2"></div>
          <div className="md:w-1/2 text-lg text-gray-200">
            Our team offers a complete suite of social media and marketing
            services, including content creation, post-scheduling, analytics,
            and campaign management. Whether you're an emerging artist or a
            seasoned professional, we help you stand out in a crowded digital
            landscape.
          </div>
        </div>
        <div className="flex flex-col md:flex-row gap-6 justify-center mb-16">
          <button className="border border-white rounded-full px-10 py-6 text-lg font-medium text-white hover:bg-white hover:text-black transition w-full md:w-auto">
            EXPAND YOUR REACH
          </button>
          <button className="border border-white rounded-full px-10 py-6 text-lg font-medium text-white hover:bg-white hover:text-black transition w-full md:w-auto">
            GENERATE PASSIVE INCOME
          </button>
          <button className="border border-white rounded-full px-10 py-6 text-lg font-medium text-white hover:bg-white hover:text-black transition w-full md:w-auto">
            SIMPLIFY MONETIZATION
          </button>
        </div>
      </section>

      {/* Service Sections */}
      <div className="bg-white text-black py-20">
        <div className="max-w-7xl mx-auto px-6 grid gap-20">
          {servicesData.map((service, idx) => (
            <div
              key={service.title}
              className={`grid md:grid-cols-2 gap-0 items-stretch`}
            >
              {/* Alternate image/text position for each row */}
              {idx % 2 === 0 ? (
                <>
                  <div className="flex items-center justify-center p-8">
                    <img
                      src={service.image}
                      alt={service.title}
                      className="rounded-xl w-full h-64 object-cover shadow-lg"
                    />
                  </div>
                  <div className="flex flex-col justify-center p-8">
                    <h2 className="text-3xl font-bold mb-4">{service.title}</h2>
                    <p className="text-lg text-gray-700 leading-relaxed">
                      {service.description}
                    </p>
                  </div>
                </>
              ) : (
                <>
                  <div className="flex flex-col justify-center p-8">
                    <h2 className="text-3xl font-bold mb-4">{service.title}</h2>
                    <p className="text-lg text-gray-700 leading-relaxed">
                      {service.description}
                    </p>
                  </div>
                  <div className="flex items-center justify-center p-8">
                    <img
                      src={service.image}
                      alt={service.title}
                      className="rounded-xl w-full h-64 object-cover shadow-lg"
                    />
                  </div>
                </>
              )}
            </div>
          ))}
        </div>
      </div>

      {/* CTA Section */}
      <section className="bg-black text-white py-24 text-center">
        <h2 className="text-5xl md:text-6xl font-black mb-8">
          JOIN US TO LEARN HOW TO
          <br />
          GET STARTED WITH ONLINE SERVICES.
        </h2>
        <p className="text-lg text-gray-200 mb-8 max-w-2xl mx-auto">
          Be part of something bigger. Nomadic Studios is more than just a place
          to work – it's a vibrant network of creatives who inspire and support
          each other.
        </p>
        <button className="bg-white text-black font-semibold px-10 py-5 rounded shadow hover:bg-gray-200 transition text-lg">
          APPLY FOR MEMBERSHIP &rarr;
        </button>
      </section>
    </div>
  );
}
