import type { MetaFunction, LoaderFunctionArgs } from "@remix-run/node";
import { useLoaderData } from "@remix-run/react";
import {
  WelcomeSection,
  StudiosSection,
  PhotoSection,
  BookSection,
} from "~/components/pages/studios";
import { MembershipSection } from "~/components/shared/MembershipSection";
import { PeopleSection } from "~/components/shared/PeopleSection";
//import { studiosConfig, type StudioType } from "~/config/studios";
import en from "~/config/lang/en.json";
import sp from "~/config/lang/sp.json";
const translations = { en, sp };

export async function loader({ params }: LoaderFunctionArgs) {
  const type = params.type;

  // get language from location storage
  const lang = "en"; //localStorage.getItem("lang") || "en";

  // get translations based on language
  const languageData = translations[lang];

  const studioData = languageData[type];

  if (!studioData) {
    throw new Response("Studio Not Found", { status: 404 });
  }

  const apiRes = await fetch(
    `https://nomadicstudios.net:444/api/studios?type=${type}`
  );
  const apiData = await apiRes.json();
  console.log(apiData);
  return Response.json({ type, studioData, apiData });
}

export const meta: MetaFunction<typeof loader> = ({ data }) => {
  if (!data) {
    return [
      { title: "Studio Not Found | Nomadics" },
      {
        name: "description",
        content: "The requested studio type was not found.",
      },
    ];
  }

  return [
    { title: data.studioData.meta.title },
    { name: "description", content: data.studioData.meta.description },
  ];
};

export default function StudioPage() {
  const { studioData, apiData } = useLoaderData<typeof loader>();

  return (
    <div>
      <WelcomeSection data={studioData.welcome} />
      <StudiosSection data={studioData.studios} />
      <PhotoSection data={studioData.gallery} />
      <BookSection
        title={studioData.book.title}
        description={studioData.book.description}
        data={apiData}
      />
      <PeopleSection title="OUR CREW" />
      <MembershipSection theme="black" />
    </div>
  );
}
