import {
  Presence,
  Primitive,
  composeEventHandlers,
  createCollection,
  createContextScope,
  useControllableState,
  useDirection,
  useId,
  useLayoutEffect2
} from "./build/_shared/chunk-FCVZVUZW.js";
import {
  EventsGrid
} from "./build/_shared/chunk-66C7QIXK.js";
import {
  HeroActions,
  HeroSection
} from "./build/_shared/chunk-4JLCL3Y3.js";
import {
  SectionHeader
} from "./build/_shared/chunk-UE4OAGIA.js";
import {
  ArrowLeft,
  ArrowRight,
  ChevronDown
} from "./build/_shared/chunk-LCP7RU5P.js";
import {
  Button,
  cn,
  useComposedRefs
} from "./build/_shared/chunk-XQGTNQYO.js";
import {
  require_jsx_runtime
} from "./build/_shared/chunk-Y3M5FCCQ.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/components/pages/home/WelcomeSection/WelcomeSection.tsx
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\WelcomeSection\\\\WelcomeSection.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\WelcomeSection\\WelcomeSection.tsx"
  );
  import.meta.hot.lastModified = "1757171103323.9631";
}
var heroActions = [{
  label: "Apply for membership",
  href: "/apply",
  variant: "fill-white",
  icon: true
}, {
  label: "Explore services",
  href: "/services",
  variant: "outline-white"
}];
function WelcomeSection() {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(HeroSection, { backgroundImage: "/images/home/welcome.png", title: "WHAT YOU NEED <br /> TO CREATE", subtitle: {
    mobile: "We empower creators to transform ideas into reality wherever they are",
    desktop: "Nomadic Studios empowers creators to transform ideas into reality wherever they are"
  }, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(HeroActions, { actions: heroActions }, void 0, false, {
    fileName: "app/components/pages/home/WelcomeSection/WelcomeSection.tsx",
    lineNumber: 38,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/pages/home/WelcomeSection/WelcomeSection.tsx",
    lineNumber: 34,
    columnNumber: 10
  }, this);
}
_c = WelcomeSection;
var _c;
$RefreshReg$(_c, "WelcomeSection");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/StudioTypesSection/components/Carousel.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime2 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\StudioTypesSection\\\\components\\\\Carousel.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\StudioTypesSection\\components\\Carousel.tsx"
  );
  import.meta.hot.lastModified = "1757171103318.746";
}
function Carousel({
  children,
  showArrows = true,
  className = ""
}) {
  _s();
  const scrollerRef = (0, import_react.useRef)(null);
  function scrollByCards(dir) {
    const el = scrollerRef.current;
    if (!el)
      return;
    const card = el.querySelector("[data-card]");
    const amount = card ? card.offsetWidth + 24 : el.clientWidth * 0.9;
    el.scrollBy({
      left: dir === "next" ? amount : -amount,
      behavior: "smooth"
    });
  }
  return /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: `relative ${className}`, children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { ref: scrollerRef, className: "flex snap-x snap-mandatory gap-6 overflow-x-auto pb-4 [-ms-overflow-style:none] [scrollbar-width:none] [&::-webkit-scrollbar]:hidden", "aria-label": "Carousel items", children }, void 0, false, {
      fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
      lineNumber: 42,
      columnNumber: 7
    }, this),
    showArrows && /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(import_jsx_dev_runtime2.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "hidden lg:flex absolute -top-[120px] right-0 items-center gap-4", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("button", { className: "w-[60px] h-[60px] rounded-full border border-neutral-900 opacity-50 flex items-center justify-center transition-opacity hover:opacity-100 !text-black", "aria-label": "Previous", onClick: () => scrollByCards("prev"), children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(ArrowLeft, { className: "h-5 w-5" }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
          lineNumber: 50,
          columnNumber: 15
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
          lineNumber: 49,
          columnNumber: 13
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("button", { className: "w-[60px] h-[60px] rounded-full border border-neutral-900 flex items-center justify-center transition-opacity hover:opacity-75 !text-black", "aria-label": "Next", onClick: () => scrollByCards("next"), children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(ArrowRight, { className: "h-5 w-5" }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
          lineNumber: 53,
          columnNumber: 15
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
          lineNumber: 52,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
        lineNumber: 48,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("div", { className: "lg:hidden mt-4 flex justify-end items-center gap-3", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("button", { className: "w-10 h-10 rounded-full border border-neutral-900 opacity-50 flex items-center justify-center transition-opacity hover:opacity-100", "aria-label": "Previous", onClick: () => scrollByCards("prev"), children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(ArrowLeft, { className: "h-4 w-4" }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
          lineNumber: 60,
          columnNumber: 15
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
          lineNumber: 59,
          columnNumber: 13
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)("button", { className: "w-10 h-10 rounded-full border border-neutral-900 flex items-center justify-center transition-opacity hover:opacity-75", "aria-label": "Next", onClick: () => scrollByCards("next"), children: /* @__PURE__ */ (0, import_jsx_dev_runtime2.jsxDEV)(ArrowRight, { className: "h-4 w-4" }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
          lineNumber: 63,
          columnNumber: 15
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
          lineNumber: 62,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
        lineNumber: 58,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
      lineNumber: 46,
      columnNumber: 22
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/pages/home/StudioTypesSection/components/Carousel.tsx",
    lineNumber: 41,
    columnNumber: 10
  }, this);
}
_s(Carousel, "Vj1mQ92rMXBGXhT22Koqyz3PHFE=");
_c2 = Carousel;
var _c2;
$RefreshReg$(_c2, "Carousel");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/StudioTypesSection/components/StudioCard.tsx
var import_jsx_dev_runtime3 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\StudioTypesSection\\\\components\\\\StudioCard.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\StudioTypesSection\\components\\StudioCard.tsx"
  );
  import.meta.hot.lastModified = "1757171103318.746";
}
function StudioCard({
  image,
  title,
  description,
  href,
  className = ""
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("article", { "data-card": "studio", className: `flex flex-col gap-4 lg:gap-6 ${className}`, children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("a", { href, className: "relative aspect-[4/3] w-full overflow-hidden group", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("img", { src: image, alt: title, className: "h-full w-full object-cover", loading: "lazy" }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
        lineNumber: 31,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "absolute inset-0 bg-neutral-900/30 opacity-0 group-hover:opacity-100 transition-opacity backdrop-blur-[10px]" }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
        lineNumber: 32,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("button", { className: "absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 px-4 lg:px-6 py-3 lg:py-[14px] border border-white/30 rounded-full opacity-0 group-hover:opacity-100 transition-opacity flex items-center gap-2", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("span", { className: "text-white text-button-small lg:text-button-big tracking-[0.02em] uppercase", children: "View" }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
          lineNumber: 34,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)(ArrowRight, { className: "h-4 lg:h-5 w-4 lg:w-5 text-white" }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
          lineNumber: 37,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
        lineNumber: 33,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
      lineNumber: 30,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "flex flex-col lg:flex-row lg:justify-between lg:items-start gap-2 lg:gap-4", children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "flex flex-col gap-1 lg:gap-2 flex-1", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("div", { className: "flex items-center justify-between", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("h3", { className: "text-heading-5 lg:text-heading-4 tracking-[-0.01em] !text-neutral-900", children: title }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
          lineNumber: 44,
          columnNumber: 13
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("a", { href, className: "lg:hidden flex items-center justify-center w-8 h-8  border border-neutral-900 shrink-0 hover:bg-neutral-900 hover:text-white transition-colors", "aria-label": `View ${title}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)(ArrowRight, { className: "h-4 w-4" }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
          lineNumber: 48,
          columnNumber: 15
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
          lineNumber: 47,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
        lineNumber: 43,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime3.jsxDEV)("p", { className: "text-body-3 !text-neutral-800/80", children: description }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
        lineNumber: 51,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
      lineNumber: 42,
      columnNumber: 9
    }, this) }, void 0, false, {
      fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
      lineNumber: 41,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/pages/home/StudioTypesSection/components/StudioCard.tsx",
    lineNumber: 29,
    columnNumber: 10
  }, this);
}
_c3 = StudioCard;
var _c3;
$RefreshReg$(_c3, "StudioCard");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx
var import_jsx_dev_runtime4 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\StudioTypesSection\\\\components\\\\StudiosSection.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\StudioTypesSection\\components\\StudiosSection.tsx"
  );
  import.meta.hot.lastModified = "1757171103320.783";
}
function StudiosSection({
  title,
  subtitle,
  items,
  isCarousel = false
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("section", { className: "relative w-full bg-white", children: /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-[120px]", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "flex flex-col gap-6 lg:gap-10", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "flex flex-col lg:flex-row lg:items-end gap-4 lg:gap-6", children: /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(SectionHeader, { eyebrow: "STUDIO TYPES", title, className: "flex-1 max-w-[991px]" }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
        lineNumber: 34,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
        lineNumber: 33,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4", children: subtitle && /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("p", { className: "text-body-3 lg:text-body-1 text-neutral-800 max-w-[763px]", children: subtitle }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
        lineNumber: 38,
        columnNumber: 26
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
        lineNumber: 37,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
      lineNumber: 32,
      columnNumber: 9
    }, this),
    isCarousel ? /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(import_jsx_dev_runtime4.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "mt-6 flex flex-col gap-6 lg:hidden", children: items.map((item) => /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(StudioCard, { image: item.image, title: item.title, description: item.description, href: item.href }, item.id, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
        lineNumber: 47,
        columnNumber: 34
      }, this)) }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
        lineNumber: 46,
        columnNumber: 13
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(Carousel, { className: "mt-6 hidden lg:block", children: items.map((item) => /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(StudioCard, { image: item.image, title: item.title, description: item.description, href: item.href, className: "snap-start shrink-0 w-[426.67px]" }, item.id, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
        lineNumber: 51,
        columnNumber: 34
      }, this)) }, void 0, false, {
        fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
        lineNumber: 50,
        columnNumber: 13
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
      lineNumber: 44,
      columnNumber: 23
    }, this) : /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)("div", { className: "mt-6 flex flex-col gap-6 lg:grid lg:grid-cols-1 md:lg:grid-cols-2 lg:grid-cols-3", children: items.map((item) => /* @__PURE__ */ (0, import_jsx_dev_runtime4.jsxDEV)(StudioCard, { image: item.image, title: item.title, description: item.description, href: item.href }, item.id, false, {
      fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
      lineNumber: 54,
      columnNumber: 32
    }, this)) }, void 0, false, {
      fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
      lineNumber: 53,
      columnNumber: 17
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
    lineNumber: 31,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/pages/home/StudioTypesSection/components/StudiosSection.tsx",
    lineNumber: 30,
    columnNumber: 10
  }, this);
}
_c4 = StudiosSection;
var _c4;
$RefreshReg$(_c4, "StudiosSection");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/StudioTypesSection/StudioTypesSection.tsx
var import_jsx_dev_runtime5 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\StudioTypesSection\\\\StudioTypesSection.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\StudioTypesSection\\StudioTypesSection.tsx"
  );
  import.meta.hot.lastModified = "1757171103317.1108";
}
var studioTypes = [{
  id: "1",
  image: "/images/home/studios/video-studios.png",
  title: "VIDEO STUDIOS",
  description: "Whether you're filming, livestreaming, or editing, our video studios are built for every stage of production.",
  href: "/studios/video"
}, {
  id: "2",
  image: "/images/home/studios/music-studios.png",
  title: "MUSIC STUDIOS",
  description: "Spaces to make your music heard. Treated rooms, pro interfaces, and backline on request.",
  href: "/studios/music"
}, {
  id: "3",
  image: "/images/home/studios/photo-studios.png",
  title: "PHOTO STUDIOS",
  description: "Our photography studios are equipped for everything from product shoots to portrait sessions.",
  href: "/studios/photo"
}];
function StudioTypesSection() {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime5.jsxDEV)(StudiosSection, { title: "STUDIOS TAILORED TO YOUR NEEDS", subtitle: "Our studios are designed with versatility in mind, providing flexible spaces that adapt to any creative pursuit.", items: studioTypes, isCarousel: true }, void 0, false, {
    fileName: "app/components/pages/home/StudioTypesSection/StudioTypesSection.tsx",
    lineNumber: 42,
    columnNumber: 10
  }, this);
}
_c5 = StudioTypesSection;
var _c5;
$RefreshReg$(_c5, "StudioTypesSection");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// node_modules/@radix-ui/react-accordion/dist/index.mjs
var import_react2 = __toESM(require_react(), 1);

// node_modules/@radix-ui/react-collapsible/dist/index.mjs
var React = __toESM(require_react(), 1);
var import_jsx_runtime = __toESM(require_jsx_runtime(), 1);
"use client";
var COLLAPSIBLE_NAME = "Collapsible";
var [createCollapsibleContext, createCollapsibleScope] = createContextScope(COLLAPSIBLE_NAME);
var [CollapsibleProvider, useCollapsibleContext] = createCollapsibleContext(COLLAPSIBLE_NAME);
var Collapsible = React.forwardRef(
  (props, forwardedRef) => {
    const {
      __scopeCollapsible,
      open: openProp,
      defaultOpen,
      disabled,
      onOpenChange,
      ...collapsibleProps
    } = props;
    const [open, setOpen] = useControllableState({
      prop: openProp,
      defaultProp: defaultOpen ?? false,
      onChange: onOpenChange,
      caller: COLLAPSIBLE_NAME
    });
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      CollapsibleProvider,
      {
        scope: __scopeCollapsible,
        disabled,
        contentId: useId(),
        open,
        onOpenToggle: React.useCallback(() => setOpen((prevOpen) => !prevOpen), [setOpen]),
        children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          Primitive.div,
          {
            "data-state": getState(open),
            "data-disabled": disabled ? "" : void 0,
            ...collapsibleProps,
            ref: forwardedRef
          }
        )
      }
    );
  }
);
Collapsible.displayName = COLLAPSIBLE_NAME;
var TRIGGER_NAME = "CollapsibleTrigger";
var CollapsibleTrigger = React.forwardRef(
  (props, forwardedRef) => {
    const { __scopeCollapsible, ...triggerProps } = props;
    const context = useCollapsibleContext(TRIGGER_NAME, __scopeCollapsible);
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      Primitive.button,
      {
        type: "button",
        "aria-controls": context.contentId,
        "aria-expanded": context.open || false,
        "data-state": getState(context.open),
        "data-disabled": context.disabled ? "" : void 0,
        disabled: context.disabled,
        ...triggerProps,
        ref: forwardedRef,
        onClick: composeEventHandlers(props.onClick, context.onOpenToggle)
      }
    );
  }
);
CollapsibleTrigger.displayName = TRIGGER_NAME;
var CONTENT_NAME = "CollapsibleContent";
var CollapsibleContent = React.forwardRef(
  (props, forwardedRef) => {
    const { forceMount, ...contentProps } = props;
    const context = useCollapsibleContext(CONTENT_NAME, props.__scopeCollapsible);
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Presence, { present: forceMount || context.open, children: ({ present }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(CollapsibleContentImpl, { ...contentProps, ref: forwardedRef, present }) });
  }
);
CollapsibleContent.displayName = CONTENT_NAME;
var CollapsibleContentImpl = React.forwardRef((props, forwardedRef) => {
  const { __scopeCollapsible, present, children, ...contentProps } = props;
  const context = useCollapsibleContext(CONTENT_NAME, __scopeCollapsible);
  const [isPresent, setIsPresent] = React.useState(present);
  const ref = React.useRef(null);
  const composedRefs = useComposedRefs(forwardedRef, ref);
  const heightRef = React.useRef(0);
  const height = heightRef.current;
  const widthRef = React.useRef(0);
  const width = widthRef.current;
  const isOpen = context.open || isPresent;
  const isMountAnimationPreventedRef = React.useRef(isOpen);
  const originalStylesRef = React.useRef(void 0);
  React.useEffect(() => {
    const rAF = requestAnimationFrame(() => isMountAnimationPreventedRef.current = false);
    return () => cancelAnimationFrame(rAF);
  }, []);
  useLayoutEffect2(() => {
    const node = ref.current;
    if (node) {
      originalStylesRef.current = originalStylesRef.current || {
        transitionDuration: node.style.transitionDuration,
        animationName: node.style.animationName
      };
      node.style.transitionDuration = "0s";
      node.style.animationName = "none";
      const rect = node.getBoundingClientRect();
      heightRef.current = rect.height;
      widthRef.current = rect.width;
      if (!isMountAnimationPreventedRef.current) {
        node.style.transitionDuration = originalStylesRef.current.transitionDuration;
        node.style.animationName = originalStylesRef.current.animationName;
      }
      setIsPresent(present);
    }
  }, [context.open, present]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    Primitive.div,
    {
      "data-state": getState(context.open),
      "data-disabled": context.disabled ? "" : void 0,
      id: context.contentId,
      hidden: !isOpen,
      ...contentProps,
      ref: composedRefs,
      style: {
        [`--radix-collapsible-content-height`]: height ? `${height}px` : void 0,
        [`--radix-collapsible-content-width`]: width ? `${width}px` : void 0,
        ...props.style
      },
      children: isOpen && children
    }
  );
});
function getState(open) {
  return open ? "open" : "closed";
}
var Root = Collapsible;
var Trigger = CollapsibleTrigger;
var Content = CollapsibleContent;

// node_modules/@radix-ui/react-accordion/dist/index.mjs
var import_jsx_runtime2 = __toESM(require_jsx_runtime(), 1);
"use client";
var ACCORDION_NAME = "Accordion";
var ACCORDION_KEYS = ["Home", "End", "ArrowDown", "ArrowUp", "ArrowLeft", "ArrowRight"];
var [Collection, useCollection, createCollectionScope] = createCollection(ACCORDION_NAME);
var [createAccordionContext, createAccordionScope] = createContextScope(ACCORDION_NAME, [
  createCollectionScope,
  createCollapsibleScope
]);
var useCollapsibleScope = createCollapsibleScope();
var Accordion = import_react2.default.forwardRef(
  (props, forwardedRef) => {
    const { type, ...accordionProps } = props;
    const singleProps = accordionProps;
    const multipleProps = accordionProps;
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Collection.Provider, { scope: props.__scopeAccordion, children: type === "multiple" ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(AccordionImplMultiple, { ...multipleProps, ref: forwardedRef }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(AccordionImplSingle, { ...singleProps, ref: forwardedRef }) });
  }
);
Accordion.displayName = ACCORDION_NAME;
var [AccordionValueProvider, useAccordionValueContext] = createAccordionContext(ACCORDION_NAME);
var [AccordionCollapsibleProvider, useAccordionCollapsibleContext] = createAccordionContext(
  ACCORDION_NAME,
  { collapsible: false }
);
var AccordionImplSingle = import_react2.default.forwardRef(
  (props, forwardedRef) => {
    const {
      value: valueProp,
      defaultValue,
      onValueChange = () => {
      },
      collapsible = false,
      ...accordionSingleProps
    } = props;
    const [value, setValue] = useControllableState({
      prop: valueProp,
      defaultProp: defaultValue ?? "",
      onChange: onValueChange,
      caller: ACCORDION_NAME
    });
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      AccordionValueProvider,
      {
        scope: props.__scopeAccordion,
        value: import_react2.default.useMemo(() => value ? [value] : [], [value]),
        onItemOpen: setValue,
        onItemClose: import_react2.default.useCallback(() => collapsible && setValue(""), [collapsible, setValue]),
        children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(AccordionCollapsibleProvider, { scope: props.__scopeAccordion, collapsible, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(AccordionImpl, { ...accordionSingleProps, ref: forwardedRef }) })
      }
    );
  }
);
var AccordionImplMultiple = import_react2.default.forwardRef((props, forwardedRef) => {
  const {
    value: valueProp,
    defaultValue,
    onValueChange = () => {
    },
    ...accordionMultipleProps
  } = props;
  const [value, setValue] = useControllableState({
    prop: valueProp,
    defaultProp: defaultValue ?? [],
    onChange: onValueChange,
    caller: ACCORDION_NAME
  });
  const handleItemOpen = import_react2.default.useCallback(
    (itemValue) => setValue((prevValue = []) => [...prevValue, itemValue]),
    [setValue]
  );
  const handleItemClose = import_react2.default.useCallback(
    (itemValue) => setValue((prevValue = []) => prevValue.filter((value2) => value2 !== itemValue)),
    [setValue]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    AccordionValueProvider,
    {
      scope: props.__scopeAccordion,
      value,
      onItemOpen: handleItemOpen,
      onItemClose: handleItemClose,
      children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(AccordionCollapsibleProvider, { scope: props.__scopeAccordion, collapsible: true, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(AccordionImpl, { ...accordionMultipleProps, ref: forwardedRef }) })
    }
  );
});
var [AccordionImplProvider, useAccordionContext] = createAccordionContext(ACCORDION_NAME);
var AccordionImpl = import_react2.default.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, disabled, dir, orientation = "vertical", ...accordionProps } = props;
    const accordionRef = import_react2.default.useRef(null);
    const composedRefs = useComposedRefs(accordionRef, forwardedRef);
    const getItems = useCollection(__scopeAccordion);
    const direction = useDirection(dir);
    const isDirectionLTR = direction === "ltr";
    const handleKeyDown = composeEventHandlers(props.onKeyDown, (event) => {
      if (!ACCORDION_KEYS.includes(event.key))
        return;
      const target = event.target;
      const triggerCollection = getItems().filter((item) => !item.ref.current?.disabled);
      const triggerIndex = triggerCollection.findIndex((item) => item.ref.current === target);
      const triggerCount = triggerCollection.length;
      if (triggerIndex === -1)
        return;
      event.preventDefault();
      let nextIndex = triggerIndex;
      const homeIndex = 0;
      const endIndex = triggerCount - 1;
      const moveNext = () => {
        nextIndex = triggerIndex + 1;
        if (nextIndex > endIndex) {
          nextIndex = homeIndex;
        }
      };
      const movePrev = () => {
        nextIndex = triggerIndex - 1;
        if (nextIndex < homeIndex) {
          nextIndex = endIndex;
        }
      };
      switch (event.key) {
        case "Home":
          nextIndex = homeIndex;
          break;
        case "End":
          nextIndex = endIndex;
          break;
        case "ArrowRight":
          if (orientation === "horizontal") {
            if (isDirectionLTR) {
              moveNext();
            } else {
              movePrev();
            }
          }
          break;
        case "ArrowDown":
          if (orientation === "vertical") {
            moveNext();
          }
          break;
        case "ArrowLeft":
          if (orientation === "horizontal") {
            if (isDirectionLTR) {
              movePrev();
            } else {
              moveNext();
            }
          }
          break;
        case "ArrowUp":
          if (orientation === "vertical") {
            movePrev();
          }
          break;
      }
      const clampedIndex = nextIndex % triggerCount;
      triggerCollection[clampedIndex].ref.current?.focus();
    });
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      AccordionImplProvider,
      {
        scope: __scopeAccordion,
        disabled,
        direction: dir,
        orientation,
        children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Collection.Slot, { scope: __scopeAccordion, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
          Primitive.div,
          {
            ...accordionProps,
            "data-orientation": orientation,
            ref: composedRefs,
            onKeyDown: disabled ? void 0 : handleKeyDown
          }
        ) })
      }
    );
  }
);
var ITEM_NAME = "AccordionItem";
var [AccordionItemProvider, useAccordionItemContext] = createAccordionContext(ITEM_NAME);
var AccordionItem = import_react2.default.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, value, ...accordionItemProps } = props;
    const accordionContext = useAccordionContext(ITEM_NAME, __scopeAccordion);
    const valueContext = useAccordionValueContext(ITEM_NAME, __scopeAccordion);
    const collapsibleScope = useCollapsibleScope(__scopeAccordion);
    const triggerId = useId();
    const open = value && valueContext.value.includes(value) || false;
    const disabled = accordionContext.disabled || props.disabled;
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      AccordionItemProvider,
      {
        scope: __scopeAccordion,
        open,
        disabled,
        triggerId,
        children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
          Root,
          {
            "data-orientation": accordionContext.orientation,
            "data-state": getState2(open),
            ...collapsibleScope,
            ...accordionItemProps,
            ref: forwardedRef,
            disabled,
            open,
            onOpenChange: (open2) => {
              if (open2) {
                valueContext.onItemOpen(value);
              } else {
                valueContext.onItemClose(value);
              }
            }
          }
        )
      }
    );
  }
);
AccordionItem.displayName = ITEM_NAME;
var HEADER_NAME = "AccordionHeader";
var AccordionHeader = import_react2.default.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, ...headerProps } = props;
    const accordionContext = useAccordionContext(ACCORDION_NAME, __scopeAccordion);
    const itemContext = useAccordionItemContext(HEADER_NAME, __scopeAccordion);
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      Primitive.h3,
      {
        "data-orientation": accordionContext.orientation,
        "data-state": getState2(itemContext.open),
        "data-disabled": itemContext.disabled ? "" : void 0,
        ...headerProps,
        ref: forwardedRef
      }
    );
  }
);
AccordionHeader.displayName = HEADER_NAME;
var TRIGGER_NAME2 = "AccordionTrigger";
var AccordionTrigger = import_react2.default.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, ...triggerProps } = props;
    const accordionContext = useAccordionContext(ACCORDION_NAME, __scopeAccordion);
    const itemContext = useAccordionItemContext(TRIGGER_NAME2, __scopeAccordion);
    const collapsibleContext = useAccordionCollapsibleContext(TRIGGER_NAME2, __scopeAccordion);
    const collapsibleScope = useCollapsibleScope(__scopeAccordion);
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Collection.ItemSlot, { scope: __scopeAccordion, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      Trigger,
      {
        "aria-disabled": itemContext.open && !collapsibleContext.collapsible || void 0,
        "data-orientation": accordionContext.orientation,
        id: itemContext.triggerId,
        ...collapsibleScope,
        ...triggerProps,
        ref: forwardedRef
      }
    ) });
  }
);
AccordionTrigger.displayName = TRIGGER_NAME2;
var CONTENT_NAME2 = "AccordionContent";
var AccordionContent = import_react2.default.forwardRef(
  (props, forwardedRef) => {
    const { __scopeAccordion, ...contentProps } = props;
    const accordionContext = useAccordionContext(ACCORDION_NAME, __scopeAccordion);
    const itemContext = useAccordionItemContext(CONTENT_NAME2, __scopeAccordion);
    const collapsibleScope = useCollapsibleScope(__scopeAccordion);
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      Content,
      {
        role: "region",
        "aria-labelledby": itemContext.triggerId,
        "data-orientation": accordionContext.orientation,
        ...collapsibleScope,
        ...contentProps,
        ref: forwardedRef,
        style: {
          ["--radix-accordion-content-height"]: "var(--radix-collapsible-content-height)",
          ["--radix-accordion-content-width"]: "var(--radix-collapsible-content-width)",
          ...props.style
        }
      }
    );
  }
);
AccordionContent.displayName = CONTENT_NAME2;
function getState2(open) {
  return open ? "open" : "closed";
}
var Root2 = Accordion;
var Item = AccordionItem;
var Header = AccordionHeader;
var Trigger2 = AccordionTrigger;
var Content2 = AccordionContent;

// app/components/ui/accordion.tsx
var import_jsx_dev_runtime6 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\ui\\\\accordion.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\ui\\accordion.tsx"
  );
  import.meta.hot.lastModified = "1757171103360.6035";
}
function Accordion2({
  ...props
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime6.jsxDEV)(Root2, { "data-slot": "accordion", ...props }, void 0, false, {
    fileName: "app/components/ui/accordion.tsx",
    lineNumber: 28,
    columnNumber: 10
  }, this);
}
_c6 = Accordion2;
function AccordionItem2({
  className,
  ...props
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime6.jsxDEV)(Item, { "data-slot": "accordion-item", className: cn("border-b last:border-b-0", className), ...props }, void 0, false, {
    fileName: "app/components/ui/accordion.tsx",
    lineNumber: 35,
    columnNumber: 10
  }, this);
}
_c22 = AccordionItem2;
function AccordionTrigger2({
  className,
  children,
  ...props
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime6.jsxDEV)(Header, { className: "flex", children: /* @__PURE__ */ (0, import_jsx_dev_runtime6.jsxDEV)(Trigger2, { "data-slot": "accordion-trigger", className: cn("focus-visible:border-ring focus-visible:ring-ring/50 flex flex-1 items-start justify-between gap-4 rounded-md py-4 text-left text-sm font-medium transition-all outline-none hover:underline focus-visible:ring-[3px] disabled:pointer-events-none disabled:opacity-50 [&[data-state=open]>svg]:rotate-180", className), ...props, children: [
    children,
    /* @__PURE__ */ (0, import_jsx_dev_runtime6.jsxDEV)(ChevronDown, { className: "text-muted-foreground pointer-events-none size-4 shrink-0 translate-y-3 transition-transform duration-200 translate-x-[-8px]" }, void 0, false, {
      fileName: "app/components/ui/accordion.tsx",
      lineNumber: 46,
      columnNumber: 9
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/ui/accordion.tsx",
    lineNumber: 44,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/ui/accordion.tsx",
    lineNumber: 43,
    columnNumber: 10
  }, this);
}
_c32 = AccordionTrigger2;
function AccordionContent2({
  className,
  children,
  ...props
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime6.jsxDEV)(Content2, { "data-slot": "accordion-content", className: "data-[state=closed]:animate-accordion-up data-[state=open]:animate-accordion-down overflow-hidden text-sm", ...props, children: /* @__PURE__ */ (0, import_jsx_dev_runtime6.jsxDEV)("div", { className: cn("pt-0 pb-4", className), children }, void 0, false, {
    fileName: "app/components/ui/accordion.tsx",
    lineNumber: 57,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/ui/accordion.tsx",
    lineNumber: 56,
    columnNumber: 10
  }, this);
}
_c42 = AccordionContent2;
var _c6;
var _c22;
var _c32;
var _c42;
$RefreshReg$(_c6, "Accordion");
$RefreshReg$(_c22, "AccordionItem");
$RefreshReg$(_c32, "AccordionTrigger");
$RefreshReg$(_c42, "AccordionContent");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/LocationsSection/components/LocationAccordion.tsx
var import_jsx_dev_runtime7 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\LocationsSection\\\\components\\\\LocationAccordion.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\LocationsSection\\components\\LocationAccordion.tsx"
  );
  import.meta.hot.lastModified = "1757171103304.8125";
}
function LocationAccordion({
  locations
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)(Accordion2, { type: "single", collapsible: true, className: "w-full", defaultValue: "1", children: locations.map((location, index) => {
    const formattedIndex = String(index + 1).padStart(2, "0");
    return /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)(AccordionItem2, { value: location.id, className: "border-b border-white/10", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)(AccordionTrigger2, { className: "hover:no-underline py-8 group [&[data-state=open]>div>svg]:rotate-180", children: /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("div", { className: "grid grid-cols-1 md:grid-cols-2 \n     items-center w-full", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("div", { className: "flex items-center gap-8", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("span", { className: "text-heading-3 font-light text-white/30 min-w-[4rem]", children: formattedIndex }, void 0, false, {
            fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
            lineNumber: 35,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("div", { children: /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("h3", { className: "text-heading-5 lg:text-heading-4 tracking-[-0.01em] text-white uppercase text-left", children: location.name }, void 0, false, {
            fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
            lineNumber: 39,
            columnNumber: 21
          }, this) }, void 0, false, {
            fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
            lineNumber: 38,
            columnNumber: 19
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
          lineNumber: 34,
          columnNumber: 17
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("span", { className: "text-body-3 text-left  text-white/60 uppercase tracking-wider ", children: location.meta }, void 0, false, {
          fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
          lineNumber: 44,
          columnNumber: 17
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("div", {}, void 0, false, {
          fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
          lineNumber: 47,
          columnNumber: 17
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
        lineNumber: 32,
        columnNumber: 15
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
        lineNumber: 31,
        columnNumber: 13
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)(AccordionContent2, { className: "pb-8 pl-[6rem]", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-4 mb-6", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("div", { className: "aspect-[4/3] overflow-hidden rounded-lg", children: /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("img", { src: location.image, alt: `${location.name}, ${location.country}`, className: "h-full w-full object-cover max-w-[500px]", loading: "lazy" }, void 0, false, {
            fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
            lineNumber: 54,
            columnNumber: 19
          }, this) }, void 0, false, {
            fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
            lineNumber: 53,
            columnNumber: 17
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("div", { className: "aspect-[4/3] overflow-hidden rounded-lg", children: /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("img", { src: location.image, alt: "Studio interior", className: "h-full w-full object-cover max-w-[500px]", loading: "lazy" }, void 0, false, {
            fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
            lineNumber: 57,
            columnNumber: 19
          }, this) }, void 0, false, {
            fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
            lineNumber: 56,
            columnNumber: 17
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
          lineNumber: 52,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("p", { className: "text-body-3 text-white/80 mb-6 ", children: location.content }, void 0, false, {
          fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
          lineNumber: 61,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("div", { className: "flex items-center justify-end", children: /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)(Button, { asChild: true, variant: "outline-white", size: "lg", className: "bg-transparent border-white/30 text-white hover:bg-white/10 hover:border-white/50 uppercase tracking-wider font-medium ", children: /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)("a", { href: location.href, className: "flex items-center gap-2", children: [
          "EXPLORE ",
          location.name,
          " STUDIOS",
          /* @__PURE__ */ (0, import_jsx_dev_runtime7.jsxDEV)(ArrowRight, { className: "h-4 w-4" }, void 0, false, {
            fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
            lineNumber: 69,
            columnNumber: 21
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
          lineNumber: 67,
          columnNumber: 19
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
          lineNumber: 66,
          columnNumber: 17
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
          lineNumber: 65,
          columnNumber: 15
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
        lineNumber: 51,
        columnNumber: 13
      }, this)
    ] }, location.id, true, {
      fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
      lineNumber: 30,
      columnNumber: 14
    }, this);
  }) }, void 0, false, {
    fileName: "app/components/pages/home/LocationsSection/components/LocationAccordion.tsx",
    lineNumber: 27,
    columnNumber: 10
  }, this);
}
_c7 = LocationAccordion;
var _c7;
$RefreshReg$(_c7, "LocationAccordion");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/LocationsSection/LocationsSection.tsx
var import_jsx_dev_runtime8 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\LocationsSection\\\\LocationsSection.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\LocationsSection\\LocationsSection.tsx"
  );
  import.meta.hot.lastModified = "1757171103304.8125";
}
var locationsData = [{
  id: "1",
  name: "BALI",
  country: "INDONESIA",
  meta: "VIDEO STUDIO / MUSIC STUDIO",
  content: "Bali is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
  href: "/locations/bali",
  image: "/images/home/locations/bali.png"
}, {
  id: "2",
  name: "BANGKOK",
  country: "THAILAND",
  meta: "VIDEO STUDIO / MUSIC STUDIO",
  content: "Bangkok is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
  href: "/locations/bangkok",
  image: "/images/home/locations/bali.png"
}, {
  id: "3",
  name: "MEXICO",
  country: "",
  meta: "PHOTOGRAPHY STUDIO / MUSIC STUDIO",
  content: "Mexico is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
  href: "/locations/mexico",
  image: "/images/home/locations/bali.png"
}, {
  id: "4",
  name: "COSTA RICA",
  country: "",
  meta: "VIDEO STUDIO / MUSIC STUDIO",
  content: "Costa Rica is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
  href: "/locations/costa-rica",
  image: "/images/home/locations/bali.png"
}, {
  id: "5",
  name: "NEW YORK",
  country: "",
  meta: "PHOTOGRAPHY STUDIO / FASHION STUDIO",
  content: "New York is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
  href: "/locations/new-york",
  image: "/images/home/locations/bali.png"
}, {
  id: "6",
  name: "MUMBAI",
  country: "",
  meta: "MUSIC STUDIO / ART STUDIO / FASHION STUDIO",
  content: "Mumbai is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
  href: "/locations/mumbai",
  image: "/images/home/locations/bali.png"
}];
function LocationsSection() {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime8.jsxDEV)("section", { className: "relative w-full bg-neutral-900 text-white", children: /* @__PURE__ */ (0, import_jsx_dev_runtime8.jsxDEV)("div", { className: "mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime8.jsxDEV)("div", { className: "mb-10 lg:mb-16", children: /* @__PURE__ */ (0, import_jsx_dev_runtime8.jsxDEV)(SectionHeader, { eyebrow: "COMMUNITIES", title: "SEE OUR LOCATIONS", className: "flex-1 max-w-[991px] [&_span]:text-white/60 [&_h2]:text-white" }, void 0, false, {
      fileName: "app/components/pages/home/LocationsSection/LocationsSection.tsx",
      lineNumber: 77,
      columnNumber: 11
    }, this) }, void 0, false, {
      fileName: "app/components/pages/home/LocationsSection/LocationsSection.tsx",
      lineNumber: 76,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime8.jsxDEV)(LocationAccordion, { locations: locationsData }, void 0, false, {
      fileName: "app/components/pages/home/LocationsSection/LocationsSection.tsx",
      lineNumber: 81,
      columnNumber: 9
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/pages/home/LocationsSection/LocationsSection.tsx",
    lineNumber: 74,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/pages/home/LocationsSection/LocationsSection.tsx",
    lineNumber: 73,
    columnNumber: 10
  }, this);
}
_c8 = LocationsSection;
var _c8;
$RefreshReg$(_c8, "LocationsSection");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx
var import_jsx_dev_runtime9 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\EquipmentSection\\\\components\\\\EquipmentAccordion.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\EquipmentSection\\components\\EquipmentAccordion.tsx"
  );
  import.meta.hot.lastModified = "1757171103296.608";
}
function EquipmentAccordion({
  equipment
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime9.jsxDEV)(Accordion2, { type: "single", collapsible: true, className: "w-full", defaultValue: "1", children: equipment.map((item) => {
    return /* @__PURE__ */ (0, import_jsx_dev_runtime9.jsxDEV)(AccordionItem2, { value: item.id, className: "border-b border-white/10", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime9.jsxDEV)(AccordionTrigger2, { className: "hover:no-underline py-6 group [&[data-state=open]>svg]:rotate-180", children: /* @__PURE__ */ (0, import_jsx_dev_runtime9.jsxDEV)("h3", { className: "text-body-2 lg:text-heading-5 tracking-[-0.01em] text-white uppercase text-left pr-4", children: item.title }, void 0, false, {
        fileName: "app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx",
        lineNumber: 30,
        columnNumber: 15
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx",
        lineNumber: 29,
        columnNumber: 13
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime9.jsxDEV)(AccordionContent2, { className: "pb-6 flex flex-col gap-4", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime9.jsxDEV)("p", { className: "text-body-3 text-white/80", children: item.content }, void 0, false, {
          fileName: "app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx",
          lineNumber: 36,
          columnNumber: 15
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime9.jsxDEV)("div", { className: "flex", children: /* @__PURE__ */ (0, import_jsx_dev_runtime9.jsxDEV)(Button, { variant: "outline-white", size: "lg", className: "bg-transparent border-white/30 text-white hover:bg-white/10 hover:border-white/50 uppercase tracking-wider font-medium", arrowRight: true, children: "BOOK A STUDIO" }, void 0, false, {
          fileName: "app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx",
          lineNumber: 41,
          columnNumber: 17
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx",
          lineNumber: 40,
          columnNumber: 15
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx",
        lineNumber: 35,
        columnNumber: 13
      }, this)
    ] }, item.id, true, {
      fileName: "app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx",
      lineNumber: 28,
      columnNumber: 14
    }, this);
  }) }, void 0, false, {
    fileName: "app/components/pages/home/EquipmentSection/components/EquipmentAccordion.tsx",
    lineNumber: 26,
    columnNumber: 10
  }, this);
}
_c9 = EquipmentAccordion;
var _c9;
$RefreshReg$(_c9, "EquipmentAccordion");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/EquipmentSection/EquipmentSection.tsx
var import_jsx_dev_runtime10 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\EquipmentSection\\\\EquipmentSection.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\EquipmentSection\\EquipmentSection.tsx"
  );
  import.meta.hot.lastModified = "1757171103296.608";
}
var equipmentData = [{
  id: "1",
  title: "CONSISTENT GEAR, WHEREVER YOU ARE",
  content: "Familiar tools make all the difference in achieving professional results. We equip our spaces globally with the gear you trust to maintain consistency in your work no matter which location you visit\u2014one can rely on getting what you want\u2014not to learning new setups."
}, {
  id: "2",
  title: "INTERCONNECTED FOR SEAMLESS COLLABORATION",
  content: "Our equipment ecosystems are designed to work together seamlessly, enabling efficient workflows and real-time collaboration across different creative disciplines and locations."
}, {
  id: "3",
  title: "SPECIALIZED RENTALS FOR UNIQUE NEEDS",
  content: "Beyond our standard equipment roster, we offer specialized rental options for unique project requirements, ensuring you have access to the exact tools needed for your creative vision."
}, {
  id: "4",
  title: "STOCKED WITH ESSENTIALS",
  content: "From cameras and audio equipment to lighting and post-production tools, our studios come fully stocked with industry-standard equipment maintained to the highest standards."
}, {
  id: "5",
  title: "EXPERT GUIDANCE ON-SITE",
  content: "Our technical staff is always available to provide guidance on equipment usage, troubleshooting, and optimization to ensure your creative process runs smoothly."
}];
function EquipmentSection() {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("section", { className: "relative w-full bg-neutral-900 text-white", children: /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("div", { className: "mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("div", { className: "mb-10 lg:mb-16", children: /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)(SectionHeader, { eyebrow: "EQUIPMENT", title: "THE EQUIPMENT YOU NEED TO CREATE", className: "flex-1 max-w-[991px] [&_span]:text-white/60 [&_h2]:text-white" }, void 0, false, {
      fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
      lineNumber: 49,
      columnNumber: 11
    }, this) }, void 0, false, {
      fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
      lineNumber: 48,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-16 items-stretch", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("div", { className: "flex flex-col", children: /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("div", { className: "aspect-[624/748] overflow-hidden rounded-lg mb-8 flex-1", children: /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("img", { src: "/images/home/equipment/studio-setup.png", alt: "Professional studio equipment setup", className: "h-full w-full object-cover", loading: "lazy" }, void 0, false, {
        fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
        lineNumber: 57,
        columnNumber: 15
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
        lineNumber: 56,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
        lineNumber: 54,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("div", { className: "flex flex-col", children: /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)("div", { className: "flex-1 flex flex-col justify-center", children: /* @__PURE__ */ (0, import_jsx_dev_runtime10.jsxDEV)(EquipmentAccordion, { equipment: equipmentData }, void 0, false, {
        fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
        lineNumber: 64,
        columnNumber: 15
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
        lineNumber: 63,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
        lineNumber: 62,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
      lineNumber: 52,
      columnNumber: 9
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
    lineNumber: 46,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/pages/home/EquipmentSection/EquipmentSection.tsx",
    lineNumber: 45,
    columnNumber: 10
  }, this);
}
_c10 = EquipmentSection;
var _c10;
$RefreshReg$(_c10, "EquipmentSection");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/EquipmentSection/index.ts
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\EquipmentSection\\index.ts"
  );
  import.meta.hot.lastModified = "1757171103296.608";
}

// app/components/pages/home/EventsSection/EventsSection.tsx
var import_jsx_dev_runtime11 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\EventsSection\\\\EventsSection.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\EventsSection\\EventsSection.tsx"
  );
  import.meta.hot.lastModified = "1759746923168.9805";
}
function EventsSection() {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)("section", { className: "relative w-full bg-white", children: /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)("div", { className: "mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)("div", { className: "grid grid-cols-1 gap-8 lg:gap-16 items-start", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)("div", { children: /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)("div", { className: "mb-6 lg:mb-8 flex  gap-4", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)(SectionHeader, { eyebrow: "EVENTS", title: "WORKSHOPS & NETWORKING", layout: "vertical", className: "[&_span]:text-black/60 [&_h2]:text-black mt-auto" }, void 0, false, {
        fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
        lineNumber: 31,
        columnNumber: 15
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)("div", { className: "*:flex flex-col gap-4", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)("p", { className: "text-body-3 lg:text-body-2 !text-black/80 max-w-[500px]", children: "Expand your knowledge and spark new ideas through our exclusive events. Workshops, discussions, and networking mixers connect you with creative minds, helping you grow and gain inspiration along the way." }, void 0, false, {
          fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
          lineNumber: 34,
          columnNumber: 17
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)("div", { className: "flex mt-8", children: /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)(Button, { variant: "outline-black", size: "lg", arrowRight: true, className: "!text-black", children: "SEE UPCOMING EVENTS" }, void 0, false, {
          fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
          lineNumber: 42,
          columnNumber: 19
        }, this) }, void 0, false, {
          fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
          lineNumber: 41,
          columnNumber: 17
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
        lineNumber: 33,
        columnNumber: 15
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
      lineNumber: 30,
      columnNumber: 13
    }, this) }, void 0, false, {
      fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
      lineNumber: 28,
      columnNumber: 11
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime11.jsxDEV)(EventsGrid, { data: [] }, void 0, false, {
      fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
      lineNumber: 50,
      columnNumber: 11
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
    lineNumber: 27,
    columnNumber: 9
  }, this) }, void 0, false, {
    fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
    lineNumber: 26,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/pages/home/EventsSection/EventsSection.tsx",
    lineNumber: 25,
    columnNumber: 10
  }, this);
}
_c11 = EventsSection;
var _c11;
$RefreshReg$(_c11, "EventsSection");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/EventsSection/index.ts
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\EventsSection\\index.ts"
  );
  import.meta.hot.lastModified = "1757171103304.8125";
}

// app/components/pages/home/SupportSection/components/SupportTile.tsx
var import_jsx_dev_runtime12 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\SupportSection\\\\components\\\\SupportTile.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\SupportSection\\components\\SupportTile.tsx"
  );
  import.meta.hot.lastModified = "1757171103323.9631";
}
function SupportTile({
  icon,
  title,
  description,
  href,
  className
}) {
  const Component = href ? "a" : "div";
  return /* @__PURE__ */ (0, import_jsx_dev_runtime12.jsxDEV)(Component, { href, className: cn("group relative flex flex-col items-left justify-center p-6 lg:p-12 ", "border border-white/20 rounded-lg", "transition-all duration-300", "hover:border-white/40 hover:bg-white/5", "h-[200px]", className), children: /* @__PURE__ */ (0, import_jsx_dev_runtime12.jsxDEV)("div", { className: "flex flex-col items-left space-y-2", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime12.jsxDEV)("div", { className: "text-white/80 transition-transform duration-300 group-hover:scale-105", children: icon }, void 0, false, {
      fileName: "app/components/pages/home/SupportSection/components/SupportTile.tsx",
      lineNumber: 32,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime12.jsxDEV)("h3", { className: "text-heading-4 transition-transform duration-300 group-hover:scale-105", children: title }, void 0, false, {
      fileName: "app/components/pages/home/SupportSection/components/SupportTile.tsx",
      lineNumber: 35,
      columnNumber: 9
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/pages/home/SupportSection/components/SupportTile.tsx",
    lineNumber: 31,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/pages/home/SupportSection/components/SupportTile.tsx",
    lineNumber: 30,
    columnNumber: 10
  }, this);
}
_c12 = SupportTile;
var _c12;
$RefreshReg$(_c12, "SupportTile");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/SupportSection/SupportSection.tsx
var import_jsx_dev_runtime13 = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\pages\\\\home\\\\SupportSection\\\\SupportSection.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\SupportSection\\SupportSection.tsx"
  );
  import.meta.hot.lastModified = "1757171103320.783";
}
var UploadIcon = () => /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("svg", { width: "34", height: "33", viewBox: "0 0 34 33", fill: "none", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("path", { d: "M17 2.08203C11.9375 2.08203 7.375 4.76953 4.875 9.08203C2.3125 13.457 2.3125 18.7695 4.875 23.082C7.375 27.457 11.9375 30.082 17 30.082C22 30.082 26.5625 27.457 29.0625 23.082C31.625 18.7695 31.625 13.457 29.0625 9.08203C26.5625 4.76953 22 2.08203 17 2.08203ZM17 32.082C11.25 32.082 6 29.082 3.125 24.082C0.25 19.1445 0.25 13.082 3.125 8.08203C6 3.14453 11.25 0.0820312 17 0.0820312C22.6875 0.0820312 27.9375 3.14453 30.8125 8.08203C33.6875 13.082 33.6875 19.1445 30.8125 24.082C27.9375 29.082 22.6875 32.082 17 32.082ZM17 7.08203C17.5625 7.08203 18.125 7.33203 18.5 7.70703L24.1875 12.957C24.6875 13.3945 25 14.0195 25 14.707C25 16.0195 23.875 17.082 22.5625 17.082H21V22.1445C21 23.7695 19.625 25.1445 18 25.1445H16C14.3125 25.1445 13 23.7695 13 22.1445V17.1445H11.375C10.0625 17.1445 9 16.0195 9 14.707C9 14.082 9.25 13.3945 9.75 12.957L15.4375 7.70703C15.875 7.33203 16.375 7.08203 17 7.08203ZM16.8125 9.20703L11.125 14.457C11 14.5195 11 14.582 11 14.707C11 14.957 11.125 15.082 11.375 15.082H14C14.5 15.082 15 15.582 15 16.082V22.1445C15 22.6445 15.4375 23.1445 16 23.1445H18C18.5 23.1445 19 22.6445 19 22.1445V16.1445C19 15.582 19.4375 15.1445 20 15.1445H22.5625C22.8125 15.1445 23 14.957 23 14.707C23 14.6445 22.9375 14.5195 22.875 14.457L17.1875 9.20703C17.125 9.14453 17.0625 9.08203 17 9.08203C16.875 9.08203 16.8125 9.14453 16.8125 9.20703Z", fill: "white" }, void 0, false, {
  fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
  lineNumber: 24,
  columnNumber: 5
}, this) }, void 0, false, {
  fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
  lineNumber: 23,
  columnNumber: 26
}, this);
_c13 = UploadIcon;
var ScaleIcon = () => /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("svg", { width: "40", height: "34", viewBox: "0 0 40 34", fill: "none", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("path", { d: "M32.9375 1.76953C33.125 2.33203 32.875 2.89453 32.3125 3.08203L23.9375 5.83203C23.625 7.39453 22.5 8.58203 21 8.95703V31.082H33C33.5625 31.082 34 31.582 34 32.082C34 32.6445 33.5625 33.082 33 33.082H20C19.4375 33.082 19 32.6445 19 32.082V8.95703C18.375 8.83203 17.8125 8.51953 17.3125 8.08203L8.3125 11.082C7.8125 11.207 7.25 10.957 7.0625 10.457C6.875 9.89453 7.1875 9.33203 7.6875 9.14453L16.1875 6.33203C16.0625 5.95703 16 5.51953 16 5.08203C16 2.89453 17.8125 1.08203 20 1.08203C21.75 1.08203 23.25 2.20703 23.8125 3.76953L31.6875 1.14453C32.25 0.957031 32.8125 1.26953 32.9375 1.76953ZM27.5 21.7695C28.5625 22.582 30.125 23.082 32 23.082C33.8125 23.082 35.375 22.582 36.4375 21.7695C37.5 20.957 38 20.0195 38 19.082H26V19.0195V19.082C26 20.0195 26.4375 20.957 27.5 21.7695ZM32 8.33203L26.625 17.082H37.3125L32 8.33203ZM24 19.082V19.0195C24 18.082 24.25 17.207 24.6875 16.3945L30.4375 6.95703C30.75 6.45703 31.375 6.08203 32 6.08203C32.5625 6.08203 33.1875 6.45703 33.5 6.95703L39.25 16.3945C39.6875 17.207 40 18.082 40 19.0195V19.082C40 22.3945 36.375 25.082 32 25.082C27.5625 25.082 24 22.3945 24 19.082ZM2 27.082C2 28.0195 2.4375 28.957 3.5 29.7695C4.5625 30.582 6.125 31.082 8 31.082C9.8125 31.082 11.375 30.582 12.4375 29.7695C13.5 28.957 14 28.0195 14 27.082H2V27.0195V27.082ZM2.625 25.082H13.3125L8 16.332L2.625 25.082ZM8 33.082C3.5625 33.082 0 30.3945 0 27.082V27.0195C0 26.082 0.25 25.207 0.6875 24.3945L6.4375 14.957C6.75 14.457 7.375 14.082 8 14.082C8.5625 14.082 9.1875 14.457 9.5 14.957L15.25 24.3945C15.6875 25.207 16 26.082 16 27.0195V27.082C16 30.3945 12.375 33.082 8 33.082ZM20 7.08203C21.125 7.08203 22 6.20703 22 5.08203C22 4.01953 21.125 3.08203 20 3.08203C18.9375 3.08203 18 4.01953 18 5.08203C18 6.20703 18.9375 7.08203 20 7.08203Z", fill: "white" }, void 0, false, {
  fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
  lineNumber: 28,
  columnNumber: 5
}, this) }, void 0, false, {
  fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
  lineNumber: 27,
  columnNumber: 25
}, this);
_c23 = ScaleIcon;
var CreditCardIcon = () => /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("svg", { width: "32", height: "32", viewBox: "0 0 32 32", fill: "none", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("path", { d: "M10 5.08203C10 5.26953 10.0625 5.51953 10.5 5.89453C10.5625 5.95703 10.6875 6.08203 10.75 6.14453C9.8125 6.14453 8.875 6.26953 8 6.39453V5.08203C8 4.14453 8.5 3.39453 9.1875 2.76953C9.875 2.20703 10.8125 1.70703 11.875 1.33203C14 0.582031 16.875 0.0820312 20 0.0820312C23.125 0.0820312 25.9375 0.582031 28.0625 1.33203C29.125 1.70703 30.0625 2.20703 30.75 2.76953C31.4375 3.39453 32 4.14453 32 5.08203V11.582V18.707C32 19.707 31.4375 20.5195 30.75 21.082C30.125 21.707 29.1875 22.207 28.125 22.6445C27.4375 22.8945 26.75 23.082 26 23.2695V21.207C26.5 21.082 26.9375 20.8945 27.375 20.7695C28.3125 20.3945 29 20.0195 29.4375 19.6445C29.875 19.207 30 18.957 30 18.707V14.582C29.4375 14.957 28.8125 15.2695 28.125 15.5195C27.4375 15.7695 26.75 15.957 26 16.1445V14.082C26.5 13.957 26.9375 13.832 27.375 13.6445C28.3125 13.2695 29 12.8945 29.4375 12.5195C29.875 12.1445 30 11.832 30 11.6445V8.01953C29.4375 8.33203 28.8125 8.64453 28.125 8.89453C27 9.26953 25.75 9.58203 24.375 9.76953C24.25 9.64453 24.125 9.51953 24 9.45703C23.375 8.89453 22.625 8.39453 21.875 8.01953C24.0625 7.89453 25.9375 7.51953 27.4375 6.95703C28.3125 6.64453 29 6.26953 29.4375 5.89453C29.875 5.51953 30 5.26953 30 5.08203C30 4.95703 29.875 4.64453 29.4375 4.26953C29 3.95703 28.375 3.51953 27.4375 3.20703C25.5625 2.51953 22.9375 2.08203 20 2.08203C17 2.08203 14.375 2.51953 12.5625 3.20703C11.625 3.58203 10.9375 3.95703 10.5 4.33203C10.0625 4.70703 9.9375 4.95703 9.9375 5.08203H10ZM2 13.082C2 13.2695 2.0625 13.5195 2.5 13.8945C2.9375 14.2695 3.625 14.6445 4.5625 15.0195C6.375 15.6445 9 16.082 12 16.082C14.9375 16.082 17.5625 15.6445 19.4375 15.0195C20.3125 14.6445 21 14.2695 21.4375 13.8945C21.875 13.5195 22 13.2695 22 13.082C22 12.957 21.875 12.707 21.4375 12.332C21 11.957 20.375 11.582 19.4375 11.207C17.5625 10.5195 14.9375 10.082 12 10.082C9 10.082 6.375 10.5195 4.5625 11.207C3.625 11.582 2.9375 11.957 2.5 12.332C2.0625 12.707 1.9375 12.957 1.9375 13.082H2ZM0 13.082C0 12.1445 0.5 11.3945 1.1875 10.7695C1.875 10.207 2.8125 9.70703 3.875 9.33203C6 8.58203 8.875 8.08203 12 8.08203C15.125 8.08203 17.9375 8.58203 20.0625 9.33203C21.125 9.70703 22.0625 10.207 22.75 10.7695C23.4375 11.3945 24 12.1445 24 13.082V19.582V26.707C24 27.707 23.4375 28.457 22.75 29.082C22.125 29.707 21.1875 30.207 20.125 30.6445C18 31.457 15.125 31.8945 12 31.8945C8.875 31.8945 5.9375 31.457 3.8125 30.6445C2.75 30.207 1.875 29.707 1.1875 29.082C0.5 28.5195 0 27.707 0 26.707V19.582V13.082ZM22 16.0195C21.4375 16.332 20.8125 16.6445 20.0625 16.8945C17.9375 17.6445 15.125 18.082 12 18.082C8.875 18.082 6 17.6445 3.875 16.8945C3.1875 16.6445 2.5 16.332 2 16.0195V19.582C2 19.832 2.0625 20.082 2.5 20.5195C2.9375 20.8945 3.625 21.2695 4.5625 21.6445C6.375 22.332 9 22.7695 12 22.7695C14.9375 22.7695 17.5625 22.332 19.375 21.6445C20.3125 21.2695 21 20.8945 21.4375 20.5195C21.875 20.082 22 19.832 22 19.582V16.0195ZM2 26.707C2 26.8945 2.0625 27.207 2.5 27.6445C2.9375 28.0195 3.625 28.3945 4.5625 28.7695C6.375 29.457 9 29.8945 12 29.8945C14.9375 29.8945 17.5625 29.457 19.375 28.7695C20.3125 28.3945 21 28.0195 21.4375 27.6445C21.875 27.207 22 26.957 22 26.707V22.582C21.4375 22.957 20.8125 23.2695 20.125 23.5195C18 24.332 15.125 24.7695 12 24.7695C8.875 24.7695 5.9375 24.332 3.8125 23.5195C3.125 23.2695 2.5 22.957 2 22.582V26.707Z", fill: "white" }, void 0, false, {
  fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
  lineNumber: 32,
  columnNumber: 5
}, this) }, void 0, false, {
  fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
  lineNumber: 31,
  columnNumber: 30
}, this);
_c33 = CreditCardIcon;
var DollarSign = () => /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("svg", { width: "32", height: "33", viewBox: "0 0 32 33", fill: "none", xmlns: "http://www.w3.org/2000/svg", children: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("path", { d: "M12.5625 9.08203L12.25 9.33203C8.8125 11.5195 2 16.8945 2 26.082C2 28.332 3.75 30.082 6 30.082H26C28.1875 30.082 30 28.332 30 26.082C30 16.8945 23.125 11.5195 19.6875 9.33203L19.375 9.08203H12.5625ZM18.6875 7.08203H18.75L19.125 6.51953L22.1875 2.08203H9.75L12.8125 6.51953L13.25 7.08203H18.6875ZM9.5 8.76953C10.125 8.33203 10.6875 7.95703 11.1875 7.64453L10 5.95703L7.5625 2.45703C6.9375 1.45703 7.625 0.0820312 8.8125 0.0820312H23.125C24.3125 0.0820312 25.0625 1.45703 24.375 2.45703L21.9375 5.95703L20.8125 7.64453C21.25 7.95703 21.8125 8.33203 22.4375 8.76953C26.25 11.582 32 17.207 32 26.082C32 29.3945 29.3125 32.082 26 32.082H6C2.6875 32.082 0 29.3945 0 26.082C0 17.207 5.6875 11.582 9.5 8.76953ZM17 13.582V14.707C17.5 14.7695 18 14.8945 18.5 15.0195C19 15.1445 19.3125 15.707 19.1875 16.207C19.0625 16.7695 18.5 17.082 17.9375 16.957C17.25 16.7695 16.5625 16.6445 15.9375 16.582C15.4375 16.582 14.875 16.707 14.5 16.957C14.125 17.1445 14 17.3945 14 17.7695C14 17.957 14.0625 18.1445 14.4375 18.3945C14.875 18.6445 15.4375 18.832 16.25 19.082H16.3125C17 19.2695 17.875 19.582 18.5625 19.957C19.3125 20.457 19.9375 21.207 20 22.3945C20 23.582 19.375 24.457 18.5625 24.957C18.0625 25.2695 17.5 25.457 17 25.5195V26.582C17 27.1445 16.5 27.582 16 27.582C15.4375 27.582 15 27.1445 15 26.582V25.5195C14.25 25.3945 13.625 25.1445 13.0625 24.957C12.9375 24.8945 12.75 24.832 12.625 24.832C12.125 24.6445 11.875 24.082 12 23.582C12.1875 23.0195 12.75 22.7695 13.3125 22.8945C13.4375 22.957 13.5625 23.0195 13.75 23.082C14.5625 23.332 15.25 23.582 16 23.6445C16.5625 23.6445 17.125 23.5195 17.5 23.2695C17.8125 23.082 18 22.832 17.9375 22.3945C17.9375 22.1445 17.875 21.8945 17.5 21.707C17.0625 21.3945 16.4375 21.207 15.6875 20.957H15.5625C14.875 20.7695 14.0625 20.5195 13.375 20.082C12.625 19.6445 12 18.8945 12 17.7695C12 16.582 12.625 15.707 13.4375 15.207C13.9375 14.957 14.4375 14.7695 15 14.707V13.582C15 13.082 15.4375 12.582 16 12.582C16.5 12.582 17 13.082 17 13.582Z", fill: "white" }, void 0, false, {
  fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
  lineNumber: 36,
  columnNumber: 5
}, this) }, void 0, false, {
  fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
  lineNumber: 35,
  columnNumber: 26
}, this);
_c43 = DollarSign;
var supportData = [{
  id: "amplify",
  icon: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)(UploadIcon, {}, void 0, false, {
    fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
    lineNumber: 41,
    columnNumber: 9
  }, this),
  title: "AMPLIFY YOUR REACH"
}, {
  id: "protect",
  icon: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)(ScaleIcon, {}, void 0, false, {
    fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
    lineNumber: 45,
    columnNumber: 9
  }, this),
  title: "PROTECT WHAT'S YOURS"
}, {
  id: "finances",
  icon: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)(CreditCardIcon, {}, void 0, false, {
    fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
    lineNumber: 49,
    columnNumber: 9
  }, this),
  title: "MASTER YOUR FINANCES"
}, {
  id: "monetize",
  icon: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)(DollarSign, {}, void 0, false, {
    fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
    lineNumber: 53,
    columnNumber: 9
  }, this),
  title: "MONETIZE YOUR CREATIVITY"
}];
function SupportSection() {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("section", { className: "relative w-full bg-neutral-900", children: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("div", { className: "mx-auto w-full max-w-[1328px] px-4 lg:px-14 py-14 lg:py-24", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("div", { className: "grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-16", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("div", { className: "flex flex-col justify-center", children: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)(SectionHeader, { eyebrow: "ADDITIONAL SERVICES", title: "SUPPORT YOU NEED", layout: "vertical", className: "[&_span]:text-white/60 [&_h2]:text-white" }, void 0, false, {
        fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
        lineNumber: 62,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
        lineNumber: 61,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("div", { className: "flex flex-col justify-center", children: /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("p", { className: "text-body-3 lg:text-body-2 text-white/80", children: "Nomadic Studios supports your creative journey with a full range of services designed to simplify your workload, protect your work, and elevate your craft. From managing your online presence to securing your intellectual property and ensuring your finances are in order, we provide the expertise you need to thrive." }, void 0, false, {
        fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
        lineNumber: 67,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
        lineNumber: 66,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
      lineNumber: 59,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)("div", { className: "grid grid-cols-1 md:grid-cols-2 gap-6 mt-12 lg:mt-16", children: supportData.map((item) => /* @__PURE__ */ (0, import_jsx_dev_runtime13.jsxDEV)(SupportTile, { ...item }, item.id, false, {
      fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
      lineNumber: 79,
      columnNumber: 36
    }, this)) }, void 0, false, {
      fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
      lineNumber: 78,
      columnNumber: 9
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
    lineNumber: 58,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/components/pages/home/SupportSection/SupportSection.tsx",
    lineNumber: 57,
    columnNumber: 10
  }, this);
}
_c52 = SupportSection;
var _c13;
var _c23;
var _c33;
var _c43;
var _c52;
$RefreshReg$(_c13, "UploadIcon");
$RefreshReg$(_c23, "ScaleIcon");
$RefreshReg$(_c33, "CreditCardIcon");
$RefreshReg$(_c43, "DollarSign");
$RefreshReg$(_c52, "SupportSection");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

// app/components/pages/home/SupportSection/index.ts
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\pages\\home\\SupportSection\\index.ts"
  );
  import.meta.hot.lastModified = "1757171103323.9631";
}

export {
  WelcomeSection,
  StudioTypesSection,
  LocationsSection,
  EquipmentSection,
  EventsSection,
  SupportSection
};
//# sourceMappingURL=build/_shared/chunk-ALX6OYFF.js.map
