import { AppConfig } from '@remix-run/dev';
import { EntryContext, AppLoadContext, ServerBuild } from '@remix-run/node';
import { Context } from '@netlify/functions';

declare const config: AppConfig;

declare function handleRequest(request: Request, responseStatusCode: number, responseHeaders: Headers, remixContext: EntryContext, _loadContext: AppLoadContext): Promise<unknown>;

type LoadContext = AppLoadContext & Context;
/**
 * A function that returns the value to use as `context` in route `loader` and
 * `action` functions.
 *
 * You can think of this as an escape hatch that allows you to pass
 * environment/platform-specific values through to your loader/action.
 */
type GetLoadContextFunction = (request: Request, context: Context) => Promise<LoadContext> | LoadContext;
type RequestHandler = (request: Request, context: LoadContext) => Promise<Response | void>;
/**
 * See https://remix.run/docs/en/main/other-api/adapter.
 * This returns a Netlify Function handler: https://docs.netlify.com/functions/overview/.
 */
declare function createRequestHandler({ build, mode, getLoadContext, }: {
    build: ServerBuild;
    mode?: string;
    getLoadContext?: GetLoadContextFunction;
}): RequestHandler;

export { type GetLoadContextFunction, type RequestHandler, config, createRequestHandler, handleRequest };
