/**
 * @remix-run/server-runtime v2.17.0
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
async function broadcastDevReady(build, origin) {
  origin ??= process.env.REMIX_DEV_ORIGIN;
  if (!origin) throw Error("Dev server origin not set");
  let url = new URL(origin);
  url.pathname = "ping";
  let response = await fetch(url.href, {
    method: "POST",
    headers: {
      "Content-Type": "application/json"
    },
    body: JSON.stringify({
      buildHash: build.assets.version
    })
  }).catch(error => {
    console.error(`Could not reach Remix dev server at ${url}`);
    throw error;
  });
  if (!response.ok) {
    console.error(`Could not reach Remix dev server at ${url} (${response.status})`);
    throw Error(await response.text());
  }
}
function logDevReady(build) {
  console.log(`[REMIX DEV] ${build.assets.version} ready`);
}
const globalDevServerHooksKey = "__remix_devServerHooks";
function setDevServerHooks(devServerHooks) {
  // @ts-expect-error
  globalThis[globalDevServerHooksKey] = devServerHooks;
}
function getDevServerHooks() {
  // @ts-expect-error
  return globalThis[globalDevServerHooksKey];
}

export { broadcastDevReady, getDevServerHooks, logDevReady, setDevServerHooks };
