import {
  authAPI
} from "./build/_shared/chunk-4X4B3Y7G.js";
import {
  Button
} from "./build/_shared/chunk-XQGTNQYO.js";
import {
  useNavigate
} from "./build/_shared/chunk-5EQN7Y3V.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/components/auth/ResetPassword.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\ResetPassword.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\ResetPassword.tsx"
  );
  import.meta.hot.lastModified = "1760464886203.3677";
}
var ResetPassword = () => {
  _s();
  const navigate = useNavigate();
  const [isVisible, setIsVisible] = (0, import_react.useState)(false);
  const [formData, setFormData] = (0, import_react.useState)({
    email: ""
  });
  const [isLoading, setIsLoading] = (0, import_react.useState)(false);
  const [error, setError] = (0, import_react.useState)(null);
  const [success, setSuccess] = (0, import_react.useState)(false);
  (0, import_react.useEffect)(() => {
    setIsVisible(true);
  }, []);
  const handleInputChange = (e) => {
    const {
      name,
      value
    } = e.target;
    setFormData((prev) => ({
      ...prev,
      [name]: value
    }));
    if (error)
      setError(null);
  };
  const handleSubmit = async (e) => {
    e.preventDefault();
    setIsLoading(true);
    setError(null);
    try {
      const response = await authAPI.forgotPassword(formData.email);
      if (response.status) {
        navigate("/reset-password-otp", {
          state: {
            email: formData.email,
            mobile_number: response.mobile_number || "",
            requestType: "reset-password"
          }
        });
      } else {
        setError(response.error || "Failed to send OTP. Please try again.");
      }
    } catch (err) {
      console.error("Forgot password error:", err);
      setError(err instanceof Error ? err.message : "An unexpected error occurred. Please try again.");
    } finally {
      setIsLoading(false);
    }
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-40" }, void 0, false, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 78,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/80 via-[#030303]/60 to-[#030303]/80" }, void 0, false, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 79,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/ResetPassword.tsx",
      lineNumber: 77,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
        animationDelay: "0s",
        animationDuration: "3s"
      } }, void 0, false, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 84,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
        animationDelay: "1s"
      } }, void 0, false, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 88,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
        animationDelay: "2s"
      } }, void 0, false, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 91,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
        animationDelay: "1.5s",
        animationDuration: "4s"
      } }, void 0, false, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 94,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/ResetPassword.tsx",
      lineNumber: 83,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative z-10 min-h-screen flex flex-col items-center justify-center px-4 lg:px-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `text-center mb-12 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "RESET PASSWORD" }, void 0, false, {
          fileName: "app/components/auth/ResetPassword.tsx",
          lineNumber: 104,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-lg lg:text-xl text-white/80 font-light", children: "Enter your email to receive OTP on your mobile" }, void 0, false, {
          fileName: "app/components/auth/ResetPassword.tsx",
          lineNumber: 107,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 103,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `w-full max-w-md transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 shadow-2xl", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h2", { className: "text-2xl font-semibold mb-8 text-white text-center uppercase tracking-wider", children: "Reset Password" }, void 0, false, {
          fileName: "app/components/auth/ResetPassword.tsx",
          lineNumber: 115,
          columnNumber: 13
        }, this),
        success && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6 p-4 bg-green-500/20 border border-green-500/30 text-green-200 rounded-xl text-sm backdrop-blur-sm text-center", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-2", children: "\u2705 OTP sent to your mobile!" }, void 0, false, {
            fileName: "app/components/auth/ResetPassword.tsx",
            lineNumber: 119,
            columnNumber: 17
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { children: "Check your mobile for the verification code." }, void 0, false, {
            fileName: "app/components/auth/ResetPassword.tsx",
            lineNumber: 120,
            columnNumber: 17
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/ResetPassword.tsx",
          lineNumber: 118,
          columnNumber: 25
        }, this),
        error && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6 p-4 bg-red-500/20 border border-red-500/30 text-red-200 rounded-xl text-sm backdrop-blur-sm", children: error }, void 0, false, {
          fileName: "app/components/auth/ResetPassword.tsx",
          lineNumber: 124,
          columnNumber: 23
        }, this),
        !success ? (
          /* Reset Password Form */
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("form", { onSubmit: handleSubmit, className: "space-y-6", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-2", children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("label", { className: "text-white/80 text-sm font-medium uppercase tracking-wider", children: "Email Address" }, void 0, false, {
                fileName: "app/components/auth/ResetPassword.tsx",
                lineNumber: 132,
                columnNumber: 19
              }, this),
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "email", name: "email", placeholder: "Please enter your email", value: formData.email, onChange: handleInputChange, className: "w-full px-4 py-4 bg-white/10 border border-white/20 rounded-xl focus:outline-none focus:ring-2 focus:ring-orange-400 focus:border-orange-400 placeholder-white/60 text-white backdrop-blur-sm transition-all", required: true, disabled: isLoading }, void 0, false, {
                fileName: "app/components/auth/ResetPassword.tsx",
                lineNumber: 133,
                columnNumber: 19
              }, this)
            ] }, void 0, true, {
              fileName: "app/components/auth/ResetPassword.tsx",
              lineNumber: 131,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "submit", variant: "fill-white", size: "lg", className: "w-full", disabled: isLoading, arrowRight: !isLoading, children: isLoading ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children: [
              /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "animate-spin rounded-full h-5 w-5 border-b-2 border-black mr-3" }, void 0, false, {
                fileName: "app/components/auth/ResetPassword.tsx",
                lineNumber: 139,
                columnNumber: 23
              }, this),
              "Sending..."
            ] }, void 0, true, {
              fileName: "app/components/auth/ResetPassword.tsx",
              lineNumber: 138,
              columnNumber: 32
            }, this) : "Send OTP to Mobile" }, void 0, false, {
              fileName: "app/components/auth/ResetPassword.tsx",
              lineNumber: 137,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center pt-4", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "sm", onClick: () => navigate("/login"), children: "Back to Login" }, void 0, false, {
              fileName: "app/components/auth/ResetPassword.tsx",
              lineNumber: 146,
              columnNumber: 19
            }, this) }, void 0, false, {
              fileName: "app/components/auth/ResetPassword.tsx",
              lineNumber: 145,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/ResetPassword.tsx",
            lineNumber: 129,
            columnNumber: 11
          }, this)
        ) : (
          /* Success State */
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center space-y-6", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-6xl mb-4", children: "\u{1F4E7}" }, void 0, false, {
              fileName: "app/components/auth/ResetPassword.tsx",
              lineNumber: 152,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-white/80 mb-6", children: "We've sent password reset instructions to your email address." }, void 0, false, {
              fileName: "app/components/auth/ResetPassword.tsx",
              lineNumber: 153,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "fill-white", size: "lg", className: "w-full", onClick: () => navigate("/login"), arrowRight: true, children: "Back to Login" }, void 0, false, {
              fileName: "app/components/auth/ResetPassword.tsx",
              lineNumber: 156,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/ResetPassword.tsx",
            lineNumber: 151,
            columnNumber: 11
          }, this)
        )
      ] }, void 0, true, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 114,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/ResetPassword.tsx",
        lineNumber: 113,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/ResetPassword.tsx",
      lineNumber: 101,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/ResetPassword.tsx",
    lineNumber: 75,
    columnNumber: 10
  }, this);
};
_s(ResetPassword, "osf3Cqxg8851DM7IBa13rsB8XqI=", false, function() {
  return [useNavigate];
});
_c = ResetPassword;
var ResetPassword_default = ResetPassword;
var _c;
$RefreshReg$(_c, "ResetPassword");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

export {
  ResetPassword_default
};
//# sourceMappingURL=build/_shared/chunk-SVH4EMEQ.js.map
