import {
  PublicRoute
} from "./build/_shared/chunk-MYKE2GOT.js";
import "./build/_shared/chunk-4X4B3Y7G.js";
import {
  Button
} from "./build/_shared/chunk-XQGTNQYO.js";
import "./build/_shared/chunk-Y3M5FCCQ.js";
import {
  Link
} from "./build/_shared/chunk-5EQN7Y3V.js";
import "./build/_shared/chunk-2Y2CKKWM.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import "./build/_shared/chunk-ZFLKADV3.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/routes/news.tsx
var import_react2 = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\routes\\\\news.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\routes\\news.tsx"
  );
  import.meta.hot.lastModified = "1760464886205.697";
}
var styles = `
  .line-clamp-3 {
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
  }
  .line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
  }
  
  /* Custom date input styling */
  input[type="date"]::-webkit-calendar-picker-indicator {
    opacity: 0;
    position: absolute;
    right: 8px;
    width: 20px;
    height: 20px;
    cursor: pointer;
  }
  
  input[type="date"] {
    color-scheme: light;
  }
`;
var meta = () => {
  return [{
    title: "News - Nomadics Studios"
  }, {
    name: "description",
    content: "Stay updated with the latest news, insights, and stories from the creative community at Nomadics Studios."
  }];
};
var newsArticles = [{
  id: 1,
  title: "Travel as a failure",
  category: "Travel",
  author: "Akanksha Bhartaure",
  publishedAt: "5 min ago",
  excerpt: "A story about a trip to Barcelona and the lessons learned from unexpected challenges along the way.",
  image: "/bw (1).png",
  slug: "travel-as-a-failure"
}, {
  id: 2,
  title: "Travel as a fresh perspective",
  category: "Travel",
  author: "Super Admin",
  publishedAt: "2 hours ago",
  excerpt: "A story about travel and how it opens our minds to new creative possibilities and fresh perspectives.",
  image: "/image.png",
  slug: "travel-as-a-fresh-perspective"
}, {
  id: 3,
  title: "Creative Studios: The Future of Work",
  category: "Studios",
  author: "John Smith",
  publishedAt: "1 day ago",
  excerpt: "Discover how modern creative studios are reshaping the future of work for artists, filmmakers, and content creators worldwide.",
  image: "/image 210.png",
  slug: "creative-studios-future-of-work"
}, {
  id: 4,
  title: "Equipment Innovation in 2024",
  category: "Equipment",
  author: "Tech Team",
  publishedAt: "2 days ago",
  excerpt: "Explore the latest equipment innovations that are transforming creative workflows and production quality in professional studios.",
  image: "/eqi-1.png",
  slug: "equipment-innovation-2024"
}, {
  id: 5,
  title: "Building Creative Communities",
  category: "Community",
  author: "Community Team",
  publishedAt: "3 days ago",
  excerpt: "Learn how Nomadics Studios is fostering connections and collaboration among creators from diverse backgrounds and disciplines.",
  image: "/bw.png",
  slug: "building-creative-communities"
}, {
  id: 6,
  title: "Sustainable Production Practices",
  category: "Sustainability",
  author: "Green Team",
  publishedAt: "1 week ago",
  excerpt: "Discover our commitment to environmentally conscious production methods and how studios can reduce their carbon footprint.",
  image: "/service-1.png",
  slug: "sustainable-production-practices"
}];
function NewsCard({
  article,
  featured = false
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Link, { to: `/news-details/${article.slug}`, className: "group block transition-all duration-300 hover:transform hover:scale-[1.02]", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("article", { className: "bg-white shadow-lg hover:shadow-xl transition-shadow duration-300 overflow-hidden h-full flex flex-col", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "aspect-[4/3] overflow-hidden bg-neutral-100", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: article.image, alt: article.title, className: "h-full w-full object-cover transition-transform duration-500 group-hover:scale-105", onError: (e) => {
      e.currentTarget.src = "/placeholder-news.jpg";
    } }, void 0, false, {
      fileName: "app/routes/news.tsx",
      lineNumber: 129,
      columnNumber: 11
    }, this) }, void 0, false, {
      fileName: "app/routes/news.tsx",
      lineNumber: 128,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "p-6 flex-1 flex flex-col", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-4", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "inline-block px-3 py-1 bg-gray-100 text-gray-600 text-xs font-medium uppercase tracking-wider rounded", children: article.category }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 138,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 137,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h3", { className: "text-xl font-bold text-black mb-4 group-hover:text-black/80 transition-colors leading-tight", children: article.title }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 144,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-gray-600 text-sm leading-relaxed mb-6 flex-1 line-clamp-3", children: article.excerpt }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 149,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex items-center gap-3 pt-4 border-t border-gray-100", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "w-8 h-8 bg-gray-200 rounded-full flex items-center justify-center", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-xs font-semibold text-gray-600", children: article.author.charAt(0) }, void 0, false, {
            fileName: "app/routes/news.tsx",
            lineNumber: 157,
            columnNumber: 17
          }, this) }, void 0, false, {
            fileName: "app/routes/news.tsx",
            lineNumber: 156,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-sm font-medium text-gray-700", children: article.author }, void 0, false, {
            fileName: "app/routes/news.tsx",
            lineNumber: 161,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/news.tsx",
          lineNumber: 155,
          columnNumber: 13
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-xs text-gray-400", children: "\u2022" }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 163,
          columnNumber: 13
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "text-xs text-gray-500", children: article.publishedAt }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 164,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.tsx",
        lineNumber: 154,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/news.tsx",
      lineNumber: 135,
      columnNumber: 9
    }, this)
  ] }, void 0, true, {
    fileName: "app/routes/news.tsx",
    lineNumber: 126,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/routes/news.tsx",
    lineNumber: 125,
    columnNumber: 10
  }, this);
}
_c = NewsCard;
function NewsPage() {
  _s();
  const [selectedDate, setSelectedDate] = (0, import_react2.useState)("");
  const [searchTags, setSearchTags] = (0, import_react2.useState)("");
  const filteredArticles = (0, import_react2.useMemo)(() => {
    let filtered = newsArticles;
    if (searchTags.trim()) {
      const searchTerms = searchTags.toLowerCase().split(" ");
      filtered = filtered.filter((article) => searchTerms.some((term) => article.title.toLowerCase().includes(term) || article.category.toLowerCase().includes(term) || article.excerpt.toLowerCase().includes(term)));
    }
    if (selectedDate) {
      filtered = filtered.slice(0, 3);
    }
    return filtered;
  }, [searchTags, selectedDate]);
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(PublicRoute, { children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative bg-white min-h-screen", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("style", { dangerouslySetInnerHTML: {
      __html: styles
    } }, void 0, false, {
      fileName: "app/routes/news.tsx",
      lineNumber: 195,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("section", { className: "relative h-[30vh] lg:h-[35vh] overflow-hidden", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: "/bw.png", alt: "Discover our news", className: "h-full w-full object-cover" }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 202,
          columnNumber: 13
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-b from-black/20 via-black/40 to-black/60" }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 203,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.tsx",
        lineNumber: 201,
        columnNumber: 11
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative z-10 h-full flex items-end", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mx-auto w-full max-w-[1328px] px-4 lg:px-14 pb-12 lg:pb-16", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "max-w-4xl", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white mb-6 uppercase tracking-tight", children: "Discover our news" }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 210,
          columnNumber: 17
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex flex-col sm:flex-row gap-4 mt-8 mb-4", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex-1 relative", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "date", value: selectedDate, onChange: (e) => setSelectedDate(e.target.value), placeholder: "mm/dd/yyyy", className: "w-full px-4 py-3 bg-white backdrop-blur-sm border border-white/20 text-black placeholder:text-gray-500 focus:outline-none focus:bg-white focus:border-gray-300 text-sm rounded-lg transition-all" }, void 0, false, {
              fileName: "app/routes/news.tsx",
              lineNumber: 217,
              columnNumber: 21
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute right-3 top-1/2 transform -translate-y-1/2 pointer-events-none", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-4 h-4 text-gray-500", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" }, void 0, false, {
              fileName: "app/routes/news.tsx",
              lineNumber: 220,
              columnNumber: 25
            }, this) }, void 0, false, {
              fileName: "app/routes/news.tsx",
              lineNumber: 219,
              columnNumber: 23
            }, this) }, void 0, false, {
              fileName: "app/routes/news.tsx",
              lineNumber: 218,
              columnNumber: 21
            }, this)
          ] }, void 0, true, {
            fileName: "app/routes/news.tsx",
            lineNumber: 216,
            columnNumber: 19
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "flex-1 relative", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { type: "text", value: searchTags, onChange: (e) => setSearchTags(e.target.value), placeholder: "Search By Tags", className: "w-full px-4 py-3 bg-white backdrop-blur-sm border border-white/20 text-black placeholder:text-gray-500 focus:outline-none focus:bg-white focus:border-gray-300 text-sm rounded-lg transition-all" }, void 0, false, {
              fileName: "app/routes/news.tsx",
              lineNumber: 225,
              columnNumber: 21
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute right-3 top-1/2 transform -translate-y-1/2 pointer-events-none", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-4 h-4 text-gray-500", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" }, void 0, false, {
              fileName: "app/routes/news.tsx",
              lineNumber: 228,
              columnNumber: 25
            }, this) }, void 0, false, {
              fileName: "app/routes/news.tsx",
              lineNumber: 227,
              columnNumber: 23
            }, this) }, void 0, false, {
              fileName: "app/routes/news.tsx",
              lineNumber: 226,
              columnNumber: 21
            }, this)
          ] }, void 0, true, {
            fileName: "app/routes/news.tsx",
            lineNumber: 224,
            columnNumber: 19
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/news.tsx",
          lineNumber: 215,
          columnNumber: 17
        }, this),
        (searchTags || selectedDate) && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mt-4 text-white/80 text-sm", children: [
          filteredArticles.length === 0 ? "No articles found matching your search criteria" : `Showing ${filteredArticles.length} article${filteredArticles.length !== 1 ? "s" : ""}`,
          searchTags && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("span", { className: "ml-2", children: [
            'for "',
            searchTags,
            '"'
          ] }, void 0, true, {
            fileName: "app/routes/news.tsx",
            lineNumber: 237,
            columnNumber: 36
          }, this),
          (searchTags || selectedDate) && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("button", { onClick: () => {
            setSearchTags("");
            setSelectedDate("");
          }, className: "ml-3 text-white/60 hover:text-white underline", children: "Clear filters" }, void 0, false, {
            fileName: "app/routes/news.tsx",
            lineNumber: 240,
            columnNumber: 54
          }, this)
        ] }, void 0, true, {
          fileName: "app/routes/news.tsx",
          lineNumber: 235,
          columnNumber: 50
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.tsx",
        lineNumber: 209,
        columnNumber: 15
      }, this) }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 208,
        columnNumber: 13
      }, this) }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 207,
        columnNumber: 11
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/news.tsx",
      lineNumber: 199,
      columnNumber: 9
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("section", { className: "bg-neutral-50 py-12 lg:py-16", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mx-auto w-full max-w-[1328px] px-4 lg:px-14", children: filteredArticles.length > 0 ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-8 mb-16", children: filteredArticles.map((article) => /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(NewsCard, { article }, article.id, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 258,
        columnNumber: 52
      }, this)) }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 257,
        columnNumber: 17
      }, this),
      !searchTags && !selectedDate && filteredArticles.length >= 4 && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "outline-black", size: "lg", arrowRight: true, className: "text-black", children: "Load More Articles" }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 263,
        columnNumber: 21
      }, this) }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 262,
        columnNumber: 82
      }, this)
    ] }, void 0, true, {
      fileName: "app/routes/news.tsx",
      lineNumber: 256,
      columnNumber: 44
    }, this) : (
      /* No Results State */
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center py-16", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "max-w-md mx-auto", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-16 h-16 text-gray-300 mx-auto mb-6", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 1, d: "M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 271,
          columnNumber: 21
        }, this) }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 270,
          columnNumber: 19
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h3", { className: "text-xl font-semibold text-gray-700 mb-2", children: "No articles found" }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 273,
          columnNumber: 19
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-gray-500 mb-6", children: "Try adjusting your search criteria or browse all articles" }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 274,
          columnNumber: 19
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { variant: "outline-black", size: "md", onClick: () => {
          setSearchTags("");
          setSelectedDate("");
        }, children: "Show All Articles" }, void 0, false, {
          fileName: "app/routes/news.tsx",
          lineNumber: 277,
          columnNumber: 19
        }, this)
      ] }, void 0, true, {
        fileName: "app/routes/news.tsx",
        lineNumber: 269,
        columnNumber: 17
      }, this) }, void 0, false, {
        fileName: "app/routes/news.tsx",
        lineNumber: 268,
        columnNumber: 11
      }, this)
    ) }, void 0, false, {
      fileName: "app/routes/news.tsx",
      lineNumber: 254,
      columnNumber: 11
    }, this) }, void 0, false, {
      fileName: "app/routes/news.tsx",
      lineNumber: 253,
      columnNumber: 9
    }, this)
  ] }, void 0, true, {
    fileName: "app/routes/news.tsx",
    lineNumber: 194,
    columnNumber: 7
  }, this) }, void 0, false, {
    fileName: "app/routes/news.tsx",
    lineNumber: 193,
    columnNumber: 10
  }, this);
}
_s(NewsPage, "+3+0vdWnfsRXg5w62qXWa8dm2Ow=");
_c2 = NewsPage;
var _c;
var _c2;
$RefreshReg$(_c, "NewsCard");
$RefreshReg$(_c2, "NewsPage");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;
export {
  NewsPage as default,
  meta
};
//# sourceMappingURL=build/routes/news-TQOTMLXX.js.map
