# Quick Start Guide

## Setup (5 minutes)

```bash
# 1. Clone repository
git clone [repository-url]
cd nomadics-web-app

# 2. Install dependencies
bun install

# 3. Start development server
bun run dev

# 4. Open browser
http://localhost:5173
```

## Key Files to Understand

### 1. Example Route (Study This First)
**File**: `app/routes/locations.$location.tsx`

This is the template for all dynamic pages. It shows:
- How to load data
- How to pass data to components
- How to structure a page

### 2. Example Component
**File**: `app/components/pages/locations/WelcomeSection/WelcomeSection.tsx`

This shows:
- How to receive data via props
- How to structure a component
- TypeScript interfaces

### 3. Mock Data Configuration
**File**: `app/config/locations.ts`

This shows:
- How data is structured
- Where to add new content
- TypeScript types

## Your First Task

### Creating a Simple New Page

1. **Create route file**: `app/routes/test.tsx`
```typescript
export default function Test() {
  return (
    <div className="mx-auto max-w-7xl px-4 py-8">
      <h1 className="text-4xl font-bold">Test Page</h1>
      <p>This is my test page</p>
    </div>
  );
}
```

2. **Visit**: http://localhost:5173/test

### Modifying Existing Content

1. **Change homepage text**:
   - Open `app/routes/_index.tsx`
   - Modify any text you see
   - Save and see changes instantly

2. **Update location data**:
   - Open `app/config/locations.ts`
   - Change any text in the "bali" section
   - Visit http://localhost:5173/locations/bali

## Understanding the Pattern

Every dynamic page follows this flow:

```
URL Parameter → Loader Function → Config Data → Components
     ↓              ↓                 ↓            ↓
  "bali"     Get bali data    locations.ts   WelcomeSection
```

## Common Commands

```bash
# Development
bun run dev          # Start dev server
bun run build        # Build for production
bun run typecheck    # Check TypeScript

# See all routes
ls app/routes/       # List all pages

# See all components
ls app/components/   # List components
```

## File Locations Reference

| What | Where |
|------|-------|
| Pages | `app/routes/` |
| Components | `app/components/` |
| Mock Data | `app/config/` |
| Images | `public/images/` |
| Styles | `app/tailwind.css` |

## Need Help?

1. Look at existing examples in the codebase
2. Follow the same patterns you see
3. Check `DEVELOPER_GUIDE.md` for detailed information

## Next Steps

1. ✅ Get the app running locally
2. ✅ Make a small change and see it work
3. 📖 Read through one complete route file
4. 🔨 Try creating a new page
5. 📚 Refer to DEVELOPER_GUIDE.md for detailed tasks