interface EquipmentItem {
  id: string;
  name: string;
  image: string;
  href: string;
}

interface EquipmentData {
  title: string;
  items: EquipmentItem[];
}

interface EquipmentSectionProps {
  data: EquipmentData;
}

export function EquipmentSection({ data }: EquipmentSectionProps) {
  return (
    <div className="mt-12">
      <h2 className="text-heading-5 lg:text-[68px] leading-[100%] font-medium tracking-[-0.03em] uppercase text-neutral-900 mb-6">
        {data.title}
      </h2>

      <div className="border border-gray-300">
        {data.items.map((item, index) => (
          <a
            key={item.id}
            href={item.href}
            className={`flex hover:bg-gray-50 transition-colors ${
              index < data.items.length - 1 ? "border-b border-gray-300" : ""
            }`}
          >
            <div className="w-16 h-16 sm:w-20 sm:h-20 lg:w-24 lg:h-24 border-r border-gray-300 p-2">
              <img
                src={item.image}
                alt={item.name}
                className="w-full h-full object-cover"
              />
            </div>
            <div className="flex-1 p-3 sm:p-4 flex items-center">
              <span className="text-sm sm:text-base text-gray-900 font-medium">
                {item.name}
              </span>
            </div>
          </a>
        ))}
      </div>
    </div>
  );
}