import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "~/components/ui/accordion";
import type { Equipment } from "../EquipmentSection";
import { Button } from "~/components/ui/button";
import { useNavigate } from "@remix-run/react";
import { isAuthenticated } from "~/lib/api";

interface EquipmentAccordionProps {
  equipment: Equipment[];
}

export function EquipmentAccordion({ equipment }: EquipmentAccordionProps) {
  const navigate = useNavigate();

  const handleBookStudio = () => {
    if (isAuthenticated()) {
      navigate('/home');
    } else {
      navigate('/login');
    }
  };

  return (
    <Accordion type="single" collapsible className="w-full" defaultValue="1">
      {equipment.map((item) => {
        return (
          <AccordionItem
            key={item.id}
            value={item.id}
            className="border-b border-white/10"
          >
            <AccordionTrigger className="hover:no-underline py-6 group [&[data-state=open]>svg]:rotate-180">
              <h3
                className="text-body-2 lg:text-heading-5 tracking-[-0.01em] text-white uppercase text-left pr-4"
              >
                {item.title}
              </h3>
            </AccordionTrigger>

            <AccordionContent className="pb-6 flex flex-col gap-4">
              <p className="text-body-3 text-white/80">
                {item.content}
              </p>
              {/* CTA Button */}
              <div className="flex">
                <Button
                  onClick={handleBookStudio}
                  variant="outline-white"
                  size="lg"
                  className="bg-transparent border-white/30 text-white hover:bg-white/10 hover:border-white/50 uppercase tracking-wider font-medium"
                  arrowRight
                >
                  BOOK A STUDIO
                </Button>
              </div>
            </AccordionContent>
          </AccordionItem>
        );
      })}
    </Accordion>
  );
}
