import { Button } from "~/components/ui/button";
import { SectionHeader } from "~/components/shared/SectionHeader";
import { EventsGrid } from "~/components/shared/EventsGrid";
import { useNavigate } from "@remix-run/react";

export function EventsSection() {
  const navigate = useNavigate();

  const handleSeeEvents = () => {
    navigate("/events");
  };

  return (
    <section className="relative w-full bg-white overflow-hidden">
      <div className="max-w-[1400px] mx-auto px-4 lg:px-14 py-14 lg:py-24">
        <div className="grid grid-cols-1 gap-8 lg:gap-16 items-start">
          <div>
            {/* Header */}
            <div className="mb-6 lg:mb-8 flex flex-col lg:flex-row gap-4 lg:gap-6">
              <SectionHeader
                eyebrow="EVENTS"
                title="WORKSHOPS & NETWORKING"
                layout="vertical"
                className="[&_span]:text-black/60 [&_h2]:text-black mt-auto flex-shrink-0"
              />
              {/* Description */}
              <div className="flex flex-col gap-4">
                <p className="text-[14px] md:text-body-3 lg:text-body-2 2xl:text-[24px] 2xl:leading-[32px] !text-black/80 max-w-full lg:max-w-[500px] 2xl:max-w-[650px]">
                  Expand your knowledge and spark new ideas through our
                  exclusive events. Workshops, discussions, and networking
                  mixers connect you with creative minds, helping you grow and
                  gain inspiration along the way.
                </p>
                {/* CTA Button */}
                <div className="flex mt-4 lg:mt-8">
                  <Button
                    onClick={handleSeeEvents}
                    variant="outline-black"
                    size="lg"
                    arrowRight
                    className="!text-black text-xs sm:text-sm whitespace-nowrap"
                  >
                    SEE UPCOMING EVENTS
                  </Button>
                </div>
              </div>
            </div>
          </div>

          <EventsGrid data={[]} />
        </div>
      </div>
    </section>
  );
}
