import { ChevronDown } from "lucide-react";
import type { FilterOptions } from "../PeopleSection";

interface PeopleToolbarProps {
  filters: {
    location: string;
    role: string;
  };
  filterOptions: FilterOptions;
  onChange: (filters: { location: string; role: string }) => void;
}

export function PeopleToolbar({
  filters,
  filterOptions,
  onChange,
}: PeopleToolbarProps) {
  const handleLocationChange = (location: string) => {
    onChange({
      ...filters,
      location: filters.location === location ? "" : location,
    });
  };

  const handleRoleChange = (role: string) => {
    onChange({
      ...filters,
      role: filters.role === role ? "" : role,
    });
  };

  return (
    <div className="mb-8 lg:mb-12 flex flex-col sm:flex-row gap-4">
      {/* Location Filter */}
      <div className="relative">
        <select
          value={filters.location}
          onChange={(e) => handleLocationChange(e.target.value)}
          className="appearance-none bg-transparent border border-black/20 rounded-none px-4 py-3 pr-10 text-button-small uppercase tracking-wider text-black focus:outline-none focus:border-black/40 min-w-[200px]"
        >
          <option value="">ALL LOCATIONS</option>
          {filterOptions.locations.map((location) => (
            <option key={location} value={location}>
              {location.toUpperCase()}
            </option>
          ))}
        </select>
        <ChevronDown className="absolute right-3 top-1/2 -translate-y-1/2 h-4 w-4 text-black/60 pointer-events-none" />
      </div>

      {/* Role Filter */}
      <div className="relative">
        <select
          value={filters.role}
          onChange={(e) => handleRoleChange(e.target.value)}
          className="appearance-none bg-transparent border border-black/20 rounded-none px-4 py-3 pr-10 text-button-small uppercase tracking-wider text-black focus:outline-none focus:border-black/40 min-w-[200px]"
        >
          <option value="">ALL ROLES</option>
          {filterOptions.roles.map((role) => (
            <option key={role} value={role}>
              {role.toUpperCase()}
            </option>
          ))}
        </select>
        <ChevronDown className="absolute right-3 top-1/2 -translate-y-1/2 h-4 w-4 text-black/60 pointer-events-none" />
      </div>

      {/* Active Filters Display */}
      {(filters.location || filters.role) && (
        <div className="flex items-center gap-2 text-body-3 text-black/60">
          <span>Active filters:</span>
          {filters.location && (
            <span className="px-2 py-1 bg-black/10 text-black rounded text-button-small uppercase">
              {filters.location}
            </span>
          )}
          {filters.role && (
            <span className="px-2 py-1 bg-black/10 text-black rounded text-button-small uppercase">
              {filters.role}
            </span>
          )}
          <button
            onClick={() => onChange({ location: "", role: "" })}
            className="text-button-small text-black/40 hover:text-black underline uppercase"
          >
            Clear all
          </button>
        </div>
      )}
    </div>
  );
}