import { StudiosSection } from "./components/StudiosSection";

const studioTypes = [
  {
    id: "1",
    image: "/images/home/studios/video-studios.png",
    title: "VIDEO STUDIOS",
    description:
      "Whether you're filming, livestreaming, or editing, our video studios are built for every stage of production.",
    href: "/studios/video",
  },
  {
    id: "2",
    image: "/images/home/studios/music-studios.png",
    title: "MUSIC STUDIOS",
    description:
      "Spaces to make your music heard. Treated rooms, pro interfaces, and backline on request.",
    href: "/studios/music",
  },
  {
    id: "3",
    image: "/images/home/studios/photo-studios.png",
    title: "PHOTO STUDIOS",
    description:
      "Our photography studios are equipped for everything from product shoots to portrait sessions.",
    href: "/studios/photo",
  },
  {
    id: "4",
    image: "/images/home/studios/art-studios.png",
    title: "ART STUDIOS",
    description:
      "Our art studios are equipped for everything from painting to sculpture.",
    href: "/studios/art",
  },
  {
    id: "5",
    image: "/images/home/studios/fashion-studios.png",
    title: "FASHION STUDIOS",
    description:
      "Our fashion studios are equipped for everything from runway shows to design workshops.",
    href: "/studios/fashion",
  },
  {
    id: "6",
    image: "/images/home/studios/maker-studios.png",
    title: "MAKER SPACE STUDIOS",
    description: "Our maker space studios are equipped for everything.",
    href: "/studios/maker",
  },
];

export function StudioTypesSection() {
  return (
    <StudiosSection
      title="STUDIOS TAILORED TO YOUR NEEDS"
      subtitle="Our studios are designed with versatility in mind, providing flexible spaces that adapt to any creative pursuit."
      items={studioTypes}
      isCarousel={true}
    />
  );
}
