import { ArrowRight } from "lucide-react";

interface StudioCardProps {
  image: string;
  title: string;
  description: string;
  href: string;
  className?: string;
}

export function StudioCard({
  image,
  title,
  description,
  href,
  className = "",
}: StudioCardProps) {
  return (
    <article
      data-card="studio"
      className={`flex flex-col gap-4 lg:gap-6 ${className}`}
    >
      <a
        href={href}
        className="relative aspect-[4/3] w-full overflow-hidden group"
      >
        <img
          src={image}
          alt={title}
          className="h-full w-full object-cover"
          loading="lazy"
        />
        <div className="absolute inset-0 bg-neutral-900/30 opacity-0 group-hover:opacity-100 transition-opacity backdrop-blur-[10px]" />
        <button className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 px-4 lg:px-6 py-3 lg:py-[14px] border border-white/30 rounded-full opacity-0 group-hover:opacity-100 transition-opacity flex items-center gap-2">
          <span className="text-white text-button-small lg:text-button-big 2xl:text-lg tracking-[0.02em] uppercase">
            View
          </span>
          <ArrowRight className="h-4 lg:h-5 w-4 lg:w-5 text-white" />
        </button>
      </a>

      <div className="flex flex-col lg:flex-row lg:justify-between lg:items-start gap-2 lg:gap-4">
        <div className="flex flex-col gap-1 lg:gap-2 flex-1">
          <div className="flex items-center justify-between gap-2">
            <h3 className="text-heading-5 lg:text-heading-4 2xl:text-[32px] tracking-[-0.01em] !text-neutral-900 flex-1 min-w-0">
              {title}
            </h3>
            <a
              href={href}
              className="lg:hidden flex items-center justify-center w-8 h-8 min-w-[32px] border border-neutral-900 shrink-0 hover:bg-neutral-900 hover:text-white transition-colors"
              aria-label={`View ${title}`}
            >
              <ArrowRight className="h-4 w-4 text-neutral-900" strokeWidth={2} />
            </a>
          </div>
          <p className="text-body-3 2xl:text-[20px] 2xl:leading-[28px] !text-neutral-800/80">{description}</p>
        </div>
      </div>
    </article>
  );
}
