import { SectionHeader } from "~/components/shared/SectionHeader";
import { Carousel } from "./Carousel";
import { StudioCard } from "./StudioCard";

export type StudioItem = {
  id: string;
  image: string;
  title: string;
  description: string;
  href: string;
};

interface StudiosSectionProps {
  title: string;
  subtitle?: string;
  items: StudioItem[];
  isCarousel?: boolean;
}

export function StudiosSection({
  title,
  subtitle,
  items,
  isCarousel = false,
}: StudiosSectionProps) {
  return (
    <section className="relative w-full bg-white overflow-hidden">
      <div className="max-w-[1400px] mx-auto px-4 lg:px-14 py-14 lg:py-[120px]">
        <div className="flex flex-col gap-6 lg:gap-10">
          <div className="flex flex-col lg:flex-row lg:items-end gap-4 lg:gap-6">
            <SectionHeader
              eyebrow="STUDIO TYPES"
              title={title}
              className="flex-1 max-w-[991px]"
            />
          </div>

          <div className="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            {subtitle && (
              <p className="text-body-3 lg:text-body-1 2xl:text-[28px] 2xl:leading-[36px] text-neutral-800 max-w-[763px] 2xl:max-w-[900px]">
                {subtitle}
              </p>
            )}
          </div>
        </div>

        {isCarousel ? (
          <>
            {/* Mobile: Vertical layout */}
            <div className="mt-6 flex flex-col gap-6 lg:hidden">
              {items.map((item) => (
                <StudioCard
                  key={item.id}
                  image={item.image}
                  title={item.title}
                  description={item.description}
                  href={item.href}
                />
              ))}
            </div>
            {/* Desktop: Carousel */}
            <Carousel className="mt-6 hidden lg:block">
              {items.map((item) => (
                <StudioCard
                  key={item.id}
                  image={item.image}
                  title={item.title}
                  description={item.description}
                  href={item.href}
                  className="snap-start shrink-0 w-[426.67px]"
                />
              ))}
            </Carousel>
          </>
        ) : (
          <div className="mt-6 flex flex-col gap-6 lg:grid lg:grid-cols-1 md:lg:grid-cols-2 lg:grid-cols-3">
            {items.map((item) => (
              <StudioCard
                key={item.id}
                image={item.image}
                title={item.title}
                description={item.description}
                href={item.href}
              />
            ))}
          </div>
        )}
      </div>
    </section>
  );
}
