import { cn } from "~/lib/utils";

interface SupportTileProps {
  icon: React.ReactNode;
  title: string;
  description?: string;
  href?: string;
  className?: string;
}

export function SupportTile({
  icon,
  title,
  description,
  href,
  className,
}: SupportTileProps) {
  const Component = href ? "a" : "div";

  return (
    <Component
      href={href}
      className={cn(
        "group relative flex flex-col items-left justify-center p-6 lg:p-12 ",
        "border border-white/20 rounded-lg",
        "transition-all duration-300",
        "hover:border-white/40 hover:bg-white/5",
        "h-[200px]",
        className
      )}
    >
      <div className="flex flex-col items-left space-y-2">
        <div className="text-white/80 transition-transform duration-300 group-hover:scale-105">
          {icon}
        </div>
        <h3 className="text-heading-4 transition-transform duration-300 group-hover:scale-105">
          {title}
        </h3>
      </div>
    </Component>
  );
}
