import { useNavigate } from "@remix-run/react";
import { HeroSection } from "./components/HeroSection";
import { HeroActions } from "./components/HeroActions";
import { isAuthenticated } from "~/lib/api";

export function WelcomeSection() {
  const navigate = useNavigate();

  const handleApplyMembership = () => {
    if (isAuthenticated()) {
      navigate('/account-settings?tab=membership');
    } else {
      navigate('/signup');
    }
  };

  const heroActions = [
    {
      label: "Apply for membership",
      onClick: handleApplyMembership,
      variant: "fill-white" as const,
      icon: true,
    },
    {
      label: "Explore services",
      href: "/services",
      variant: "outline-white" as const,
    },
  ];

  return (
    <HeroSection
      backgroundVideo="/intro.mp4"
      title="WHAT YOU NEED <br /> TO CREATE"
      subtitle={{
        mobile:
          "We empower creators to transform ideas into reality wherever they are",
        desktop:
          "Nomadic Studios empowers creators to transform ideas into reality wherever they are",
      }}
    >
      <HeroActions actions={heroActions} />
    </HeroSection>
  );
}
