interface HeroSectionProps {
  backgroundImage?: string;
  backgroundVideo?: string;
  title: string;
  subtitle?:
    | {
        mobile?: string;
        desktop?: string;
      }
    | string;
  children?: React.ReactNode;
}

export function HeroSection({
  backgroundImage,
  backgroundVideo,
  title,
  subtitle,
  children,
}: HeroSectionProps) {
  return (
    <section className="relative w-full h-screen flex flex-col">
      {/* Background */}
      <div className="absolute inset-0 bg-[#030303]" />
      {backgroundVideo ? (
        <video
          autoPlay
          muted
          loop
          playsInline
          className="absolute inset-0 h-full w-full object-cover"
        >
          <source src={backgroundVideo} type="video/mp4" />
        </video>
      ) : backgroundImage ? (
        <img
          src={backgroundImage}
          alt=""
          className="absolute inset-0 h-full w-full object-cover"
        />
      ) : null}

      {/* Content - Centered */}
      <div className="absolute left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2 w-full flex flex-col items-center justify-center gap-4 px-4 lg:px-0">
        <div className="text-center">
          <h1
            className="text-[28px] sm:text-[32px] md:text-[56px] lg:text-heading-1 2xl:text-[80px] uppercase text-white mb-4 font-bold tracking-[-0.02em] leading-[1.1]"
            dangerouslySetInnerHTML={{ __html: title }}
          />

          {subtitle && (
            <>
              {typeof subtitle === "string" ? (
                <p className="text-center text-sm sm:text-body-3 md:text-body-2 lg:text-body-1 2xl:text-[24px] text-white/80 max-w-[500px] sm:max-w-[600px] 2xl:max-w-[800px] mx-auto px-4 sm:px-0">
                  {subtitle}
                </p>
              ) : (
                <>
                  {subtitle.mobile && (
                    <p className="lg:hidden text-center text-sm sm:text-body-3 md:text-body-2 text-white/80 max-w-[500px] sm:max-w-[600px] mx-auto px-4 sm:px-0">
                      {subtitle.mobile}
                    </p>
                  )}
                </>
              )}
            </>
          )}
        </div>
      </div>

      {/* Bottom Actions */}
      {children && (
        <div className="relative flex-1 flex flex-col items-center justify-end px-4 lg:px-14 pb-8 lg:pb-12">
          <div className="flex items-center justify-center w-full max-w-[1400px]">
            {children}
            {subtitle &&
              typeof subtitle !== "string" &&
              "desktop" in subtitle && (
                <p className="hidden lg:block text-right text-body-1 2xl:text-[32px] 2xl:font-semibold 2xl:leading-[44px] text-white/90 max-w-[600px] 2xl:max-w-[800px] ml-auto">
                  {subtitle.desktop}
                </p>
              )}
          </div>
        </div>
      )}
    </section>
  );
}
