import { SectionHeader } from "~/components/shared/SectionHeader";

interface LocationInfoData {
  title: string;
  description: string;
  stats: Array<{ number: string; label: string }>;
}

interface LocationInfoProps {
  data: LocationInfoData;
}

export function LocationInfo({ data }: LocationInfoProps) {
  return (
    <section className="w-full bg-white py-12 lg:py-20">
      <div className="max-w-[1400px] mx-auto px-4 lg:px-14">
        <SectionHeader eyebrow="ABOUT" title={data.title} />

        <div className="my-12 lg:my-16">
          <p className="text-base lg:text-lg text-neutral-900 leading-relaxed max-w-5xl">
            {data.description}
          </p>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-3 gap-6 lg:gap-8">
          {data.stats.map((stat, index) => (
            <div
              key={index}
              className="border border-body-80 rounded-[999px] px-6 lg:px-8 py-6 lg:py-12 text-center flex justify-center items-center gap-[12px]"
            >
              <div className="text-stat-number text-neutral-900">
                {stat.number}
              </div>
              <div className="text-stat-label text-neutral-600 whitespace-pre-line">
                {stat.label}
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
}
