import { SectionHeader } from "~/components/shared/SectionHeader";
import { ImageGrid, type ImageGridItem } from "~/components/shared/ImageGrid";
import { useNavigate } from "@remix-run/react";

interface Studio {
  id: string;
  image: string;
  title: string;
}

interface StudiosData {
  sectionTitle: string;
  studios: Studio[];
}

interface StudiosSectionProps {
  data: StudiosData;
}

export function StudiosSection({ data }: StudiosSectionProps) {
  const navigate = useNavigate();
  console.log("StudiosSection received data:", data);
  console.log("Studios array:", data.studios);

  const items: ImageGridItem[] = data.studios.map((studio: any) => {
    console.log("StudiosSection mapping studio:", studio);
    console.log("Studio has onClick?", !!studio.onClick);
    console.log("Studio onClick type:", typeof studio.onClick);

    // If onClick is already provided in the studio data, use it
    if (studio.onClick) {
      console.log("Using provided onClick for studio:", studio.title);
      return {
        id: studio.id,
        image: studio.image,
        title: studio.title,
        onClick: studio.onClick,
      };
    }

    // Otherwise, create onClick handler from slug
    const slug = studio.studio_slug || studio.slug || studio.id;
    console.log(
      "Creating onClick with slug:",
      slug,
      "for studio:",
      studio.title
    );

    return {
      id: studio.id,
      image: studio.image,
      title: studio.title,
      onClick: () => {
        console.log("StudiosSection onClick called for slug:", slug);
        if (slug) {
          navigate(`/studio/${slug}`);
        }
      },
    };
  });

  console.log("StudiosSection final items:", items);

  return (
    <section id="studios-section" className="relative w-full bg-white">
      <div className="max-w-[1400px] mx-auto px-4 lg:px-14 py-14 lg:py-24">
        {/* <SectionHeader title={data.sectionTitle} className="mb-4 px-2 lg:px-6" /> */}
        <ImageGrid items={items} />
      </div>
    </section>
  );
}
