import { HeroSection } from "../../home/WelcomeSection/components/HeroSection";
import { HeroActions } from "../../home/WelcomeSection/components/HeroActions";

export type LocationType = "bali" | "bangkok" | "mexico" | "costa-rica" | "new-york" | "mumbai";

interface WelcomeData {
  title: string;
  subtitle: string;
  backgroundImage: string;
  meta: string;
}

interface WelcomeSectionProps {
  data: WelcomeData;
}

export function WelcomeSection({ data }: WelcomeSectionProps) {
  
  const handleScrollToStudios = () => {
    const studiosSection = document.getElementById('studios-section');
    if (studiosSection) {
      studiosSection.scrollIntoView({ behavior: 'smooth' });
    }
  };

  const heroActions = [
    {
      label: "Book a studio",
      onClick: handleScrollToStudios,
      variant: "fill-white" as const,
      icon: true,
    },
  ];

  return (
    <HeroSection
      backgroundImage={data.backgroundImage}
      title={data.title}
      subtitle={data.subtitle}
    >
      <HeroActions actions={heroActions} />
    </HeroSection>
  );
}