import { ImageGrid, type ImageGridItem } from "~/components/shared/ImageGrid";

interface BookData {
  items: ImageGridItem[];
}

interface BookSectionProps {
  title: string;
  description: string;
  data: BookData;
}

export function BookSection({ title, description, data }: BookSectionProps) {
  return (
    <section className="relative w-full bg-white">
      <div className="max-w-[1400px] mx-auto px-4 lg:px-14 py-12 sm:py-16 lg:py-24">
        {/* Header */}
        <div className="text-center mb-12">
          <h2 className="text-heading-3 lg:text-heading-2 2xl:text-heading-2 font-medium uppercase tracking-tight text-[#121212] font-clash-grotesk mb-4 !text-black">
            {title}
          </h2>
          <p className="text-body-2 lg:text-body-1 2xl:text-body-1 text-[rgba(18,18,18,0.7)] max-w-2xl 2xl:max-w-4xl mx-auto mb-8 !text-black">
            {description}
          </p>
        </div>

        {/* Studio Options Grid */}
        <ImageGrid items={data.items} />
      </div>
    </section>
  );
}
