interface StudioItem {
  title: string;
  description: string;
  image: string;
  imagePosition: "left" | "right";
}

interface StudiosSectionProps {
  data: StudioItem[];
}

interface StudioRowProps {
  item: StudioItem;
}

function StudioRow({ item }: StudioRowProps) {
  return (
    <div className="flex flex-col lg:flex-row lg:justify-end lg:items-center w-full  border-t border-[rgba(18,18,18,0.2)]">
      {item.imagePosition === "right" ? (
        <>
          {/* Mobile: Image on top, Desktop: Text on left */}
          <div className="lg:hidden w-full p-4">
            <img
              src={item.image}
              alt={item.title}
              className="w-full h-full object-cover"
            />
          </div>

          {/* Text Content - Mobile: Below image, Desktop: Left Side */}
          <div className="flex flex-col items-start px-4 sm:px-6 md:px-8 lg:px-14 py-6 sm:py-8 lg:py-0 gap-3 sm:gap-4 lg:flex-1 lg:self-center">
            <h2 className="text-heading-5 sm:text-heading-4 lg:text-heading-3 2xl:text-heading-3 leading-[28px] sm:leading-[32px] lg:leading-[48px] 2xl:leading-[48px] font-medium 2xl:font-bold uppercase tracking-[-0.01em] text-[#121212] font-clash-grotesk !text-black">
              {item.title}
            </h2>
            <p className="text-body-3 sm:text-body-3 lg:text-body-1 2xl:text-body-1 leading-[20px] sm:leading-[24px] lg:leading-[32px] 2xl:leading-[32px] font-normal 2xl:font-medium text-[rgba(18,18,18,0.8)] font-clash-grotesk !text-black">
              {item.description}
            </p>
          </div>

          {/* Image - Desktop: Right Side */}
          <div className="hidden lg:flex flex-row items-center px-6 lg:px-14 gap-2 lg:w-1/2 xl:w-[612px] min-h-[400px] lg:h-[551px] border-l border-[rgba(18,18,18,0.2)]">
            <div className="flex flex-col items-start p-6 lg:p-10 gap-2 w-full max-w-[500px] aspect-[4/3] flex-1">
              <img
                src={item.image}
                alt={item.title}
                className="w-full h-full object-cover"
              />
            </div>
          </div>
        </>
      ) : (
        <>
          {/* Mobile: Image on top, Desktop: Image on left */}
          <div className="lg:hidden w-full h-[250px] sm:h-[300px] md:h-[350px] p-4">
            <img
              src={item.image}
              alt={item.title}
              className="w-full h-full object-cover rounded-lg"
            />
          </div>

          {/* Image - Desktop: Left Side */}
          <div className="hidden lg:flex flex-row items-center px-6 lg:px-14 gap-2 lg:w-1/2 xl:w-[612px] min-h-[400px] lg:h-[551px] border-r border-[rgba(18,18,18,0.2)]">
            <div className="flex flex-col items-start p-6 lg:p-10 gap-2 w-full max-w-[500px] aspect-[4/3] flex-1">
              <img
                src={item.image}
                alt={item.title}
                className="w-full h-full object-cover"
              />
            </div>
          </div>

          {/* Text Content - Mobile: Below image, Desktop: Right Side */}
          <div className="flex flex-col items-start px-4 sm:px-6 md:px-8 lg:px-14 py-6 sm:py-8 lg:py-0 gap-3 sm:gap-4 lg:flex-1 lg:self-center">
            <h2 className="text-heading-5 sm:text-heading-4 lg:text-heading-3 2xl:text-heading-3 leading-[28px] sm:leading-[32px] lg:leading-[48px] 2xl:leading-[48px] font-medium 2xl:font-bold uppercase tracking-[-0.01em] text-[#121212] font-clash-grotesk !text-black">
              {item.title}
            </h2>
            <p className="text-body-3 sm:text-body-3 lg:text-body-1 2xl:text-body-1 leading-[20px] sm:leading-[24px] lg:leading-[32px] 2xl:leading-[32px] font-normal 2xl:font-medium text-[rgba(18,18,18,0.8)] font-clash-grotesk !text-black">
              {item.description}
            </p>
          </div>
        </>
      )}
    </div>
  );
}

export function StudiosSection({ data }: StudiosSectionProps) {
  return (
    <section id="studios" className="w-full bg-white">
      <div className="max-w-[1400px] mx-auto px-4 lg:px-14">
        {data.map((item, index) => (
          <StudioRow key={index} item={item} />
        ))}
      </div>
    </section>
  );
}
