import { useNavigate } from "@remix-run/react";
import { HeroSection } from "../../home/WelcomeSection/components/HeroSection";
import { HeroActions } from "../../home/WelcomeSection/components/HeroActions";
import { isAuthenticated } from "~/lib/api";

interface WelcomeData {
  title: string;
  subtitle: string;
  backgroundImage: string;
  ctaLabel: string;
  ctaHref: string;
}

interface WelcomeSectionProps {
  data: WelcomeData;
}

export function WelcomeSection({ data }: WelcomeSectionProps) {
  const navigate = useNavigate();

  const handleCtaClick = () => {
    if (isAuthenticated()) {
      navigate('/home');
    } else {
      navigate('/login');
    }
  };

  const heroActions = [
    {
      label: data.ctaLabel,
      onClick: handleCtaClick,
      variant: "fill-white" as const,
      icon: true,
    },
  ];

  return (
    <HeroSection
      backgroundImage={data.backgroundImage}
      title={data.title}
      subtitle={data.subtitle}
    >
      <HeroActions actions={heroActions} />
    </HeroSection>
  );
}