import { Button } from "~/components/ui/button";

interface BookingFormProps {
  defaultStartTime?: string;
  defaultEndTime?: string;
  duration?: string;
  points?: string;
}

export function BookingForm({
  defaultStartTime = "2025-08-21T10:30",
  defaultEndTime = "2025-08-21T13:30",
  duration = "3h",
  points = "130 points",
}: BookingFormProps) {
  return (
    <div className="bg-white border border-gray-200  p-6">
      <form className="space-y-2">
        <div>
          <label className="flex items-center text-sm font-medium text-gray-700 mb-2">
            <svg
              className="w-4 h-4 mr-2"
              fill="currentColor"
              viewBox="0 0 20 20"
            >
              <path
                fillRule="evenodd"
                d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                clipRule="evenodd"
              />
            </svg>
            START
          </label>
          <div className="relative">
            <input
              type="datetime-local"
              className="w-full px-4 py-3 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-black !text-black"
              defaultValue={defaultStartTime}
            />
          </div>
        </div>

        <div>
          <label className="flex items-center text-sm font-medium text-gray-700 mb-2">
            <svg
              className="w-4 h-4 mr-2"
              fill="currentColor"
              viewBox="0 0 20 20"
            >
              <path
                fillRule="evenodd"
                d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                clipRule="evenodd"
              />
            </svg>
            END
          </label>
          <div className="relative">
            <input
              type="datetime-local"
              className="w-full px-4 py-3 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-black !text-black"
              defaultValue={defaultEndTime}
            />
          </div>
        </div>

        <div className="text-sm text-gray-600 py-2">
          Your reservation: {duration} • From: {points}
        </div>

        <Button
          type="submit"
          className="w-full"
          variant="fill-black"
          size="lg"
          arrowRight
        >
          BOOK NOW
        </Button>
      </form>
    </div>
  );
}
