import { EventCard } from "./components/EventCard";

export interface Event {
  id: string;
  image: string;
  date: {
    day: string;
    month: string;
  };
  time: string;
  title: string;
  href: string;
  eventData?: any; // Optional full event data
}

// const eventsData: Event[] = [
//   {
//     id: "1",
//     image: "/images/home/events/event-1.png",
//     date: {
//       day: "08",
//       month: "JUN",
//     },
//     time: "03:30 PM",
//     title: "EVENT NAME",
//     href: "/events/event-1",
//   },
//   {
//     id: "2",
//     image: "/images/home/events/event-1.png",
//     date: {
//       day: "08",
//       month: "JUN",
//     },
//     time: "03:30 PM",
//     title: "EVENT NAME",
//     href: "/events/event-2",
//   },
//   {
//     id: "3",
//     image: "/images/home/events/event-1.png",
//     date: {
//       day: "08",
//       month: "JUN",
//     },
//     time: "03:30 PM",
//     title: "EVENT NAME",
//     href: "/events/event-3",
//   },
// ];

interface EventsGridProps {
  data: Event[];
}

export function EventsGrid({ data }: EventsGridProps) {
  return (
    <div className="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
      {data.map((event) => (
        <EventCard key={event.id} {...event} />
      ))}
    </div>
  );
}
