import { Link } from "@remix-run/react";

interface PersonCardProps {
  photo: string;
  name: string;
  surname: string;
  role: string;
  location: string;
  href: string;
}

export function PersonCard({
  photo,
  name,
  surname,
  role,
  location,
  href,
}: PersonCardProps) {
  return (
    <Link
      to={href}
      className="group block overflow-hidden transition-all duration-300 hover:scale-[1.02]"
    >
      {/* Photo - Exact Figma dimensions: 313 × 419 */}
      <div className="aspect-[313/419] overflow-hidden bg-neutral-100 mb-2 lg:mb-4">
        <img
          src={photo}
          alt={`${name} ${surname} - ${role}`}
          className="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105 grayscale group-hover:grayscale-0"
          loading="lazy"
        />
      </div>

      {/* Person Info */}
      <div className="space-y-0.5 lg:space-y-1">
        <h3 className="text-body-3 lg:text-heading-5 tracking-[-0.01em] uppercase leading-tight" style={{ color: '#000000' }}>
          {name} {surname}
        </h3>
        <p className="text-button-small lg:text-body-3 capitalize" style={{ color: 'rgba(0, 0, 0, 0.6)' }}>
          {role}
        </p>
      </div>
    </Link>
  );
}