import { useState } from "react";
import ProfilePlaceholder from "./ProfilePlaceholder";

interface ProfileImageProps {
  src?: string | null;
  alt: string;
  className?: string;
}

export default function ProfileImage({ src, alt, className = "" }: ProfileImageProps) {
  const [hasError, setHasError] = useState(false);

  if (!src || hasError) {
    return <ProfilePlaceholder className={className} />;
  }

  return (
    <img
      src={src}
      alt={alt}
      className={className}
      onError={() => setHasError(true)}
    />
  );
}
