import { cn } from "~/lib/utils";

interface SectionHeaderProps {
  title: string;
  subtitle?: string;
  eyebrow?: string;
  className?: string;
  layout?: "horizontal" | "vertical";
}

export function SectionHeader({
  title,
  eyebrow,
  className = "",
  layout = "horizontal",
}: SectionHeaderProps) {
  console.log(layout, title);
  const layoutClasses =
    layout === "vertical"
      ? "flex flex-col gap-3 lg:gap-4"
      : "flex flex-col lg:flex-row lg:items-end gap-3 lg:gap-6";

  return (
    <div className={`${layoutClasses} ${className}`}>
      {eyebrow && (
        <div className="flex items-center gap-2">
          <span className="text-button-small lg:text-base 2xl:text-lg leading-4 lg:leading-5 2xl:leading-6 tracking-[0.02em] uppercase text-neutral-900/60 whitespace-nowrap">
            [{eyebrow}]
          </span>
        </div>
      )}
      <h2
        className={cn(
          "text-[28px] md:text-[48px] lg:text-[68px] 2xl:text-[88px] leading-[100%] font-medium 2xl:font-bold tracking-[-0.03em] uppercase text-neutral-900 ",
          layout === "horizontal" ? "ml-6" : "ml-0",
          eyebrow ? "" : "!ml-0",
          className
        )}
      >
        {title}
      </h2>
    </div>
  );
}
