export interface City {
  id: string;
  name: string;
  country: string;
  locations: Location[];
}

export interface Location {
  id: string;
  name: string;
  cityId: string;
  meta: string;
  content: string;
  href: string;
  image: string;
}

// Cities with their locations
export const cities: City[] = [
  {
    id: "bali",
    name: "Bali",
    country: "Indonesia",
    locations: [
      {
        id: "bali-main",
        name: "BALI",
        cityId: "bali",
        meta: "VIDEO STUDIO / MUSIC STUDIO",
        content: "Bali is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
        href: "/locations/bali",
        image: "/images/home/locations/bali.png",
      }
    ]
  },
  {
    id: "bangkok",
    name: "Bangkok",
    country: "Thailand",
    locations: [
      {
        id: "bangkok-main",
        name: "BANGKOK",
        cityId: "bangkok",
        meta: "VIDEO STUDIO / MUSIC STUDIO",
        content: "Bangkok is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
        href: "/locations/bangkok",
        image: "/images/home/locations/bali.png",
      }
    ]
  },
  {
    id: "mexico",
    name: "Mexico",
    country: "Mexico",
    locations: [
      {
        id: "mexico-main",
        name: "MEXICO",
        cityId: "mexico",
        meta: "PHOTOGRAPHY STUDIO / MUSIC STUDIO",
        content: "Mexico is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
        href: "/locations/mexico",
        image: "/images/home/locations/bali.png",
      }
    ]
  },
  {
    id: "costa-rica",
    name: "Costa Rica",
    country: "Costa Rica",
    locations: [
      {
        id: "costa-rica-main",
        name: "COSTA RICA",
        cityId: "costa-rica",
        meta: "VIDEO STUDIO / MUSIC STUDIO",
        content: "Costa Rica is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
        href: "/locations/costa-rica",
        image: "/images/home/locations/bali.png",
      }
    ]
  },
  {
    id: "new-york",
    name: "New York",
    country: "United States",
    locations: [
      {
        id: "new-york-main",
        name: "NEW YORK",
        cityId: "new-york",
        meta: "PHOTOGRAPHY STUDIO / FASHION STUDIO",
        content: "New York is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
        href: "/locations/new-york",
        image: "/images/home/locations/bali.png",
      }
    ]
  },
  {
    id: "mumbai",
    name: "Mumbai",
    country: "India",
    locations: [
      {
        id: "mumbai-main",
        name: "MUMBAI",
        cityId: "mumbai",
        meta: "MUSIC STUDIO / ART STUDIO / FASHION STUDIO",
        content: "Mumbai is a city of innovation, culture, and creativity, and Nomadic Studios is proud to be at the heart of it. Our space here is designed to empower creators across disciplines, providing the tools, resources, and inspiration needed to take your work to the next level. Whether you're a local professional looking for a versatile studio or a traveling creator seeking a place to call your creative home, you'll find everything you need right here.",
        href: "/locations/mumbai",
        image: "/images/home/locations/bali.png",
      }
    ]
  }
];

// Helper functions
export const getAllLocations = (): Location[] => {
  return cities.flatMap(city => city.locations);
};

export const getLocationsByCity = (cityId: string): Location[] => {
  const city = cities.find(c => c.id === cityId);
  return city ? city.locations : [];
};

export const getCityById = (cityId: string): City | undefined => {
  return cities.find(c => c.id === cityId);
};

export const getLocationById = (locationId: string): Location | undefined => {
  return getAllLocations().find(l => l.id === locationId);
};

// For dropdown/selector options
export const getCityOptions = () => {
  return cities.map(city => ({
    id: city.id,
    label: city.name,
    country: city.country,
    value: city.id
  }));
};