import React, { useState } from "react";

export default function StudioPage() {
  const [start, setStart] = useState("2025-08-21T10:30");
  const [end, setEnd] = useState("2025-08-21T13:30");
  const duration =
    (new Date(end).getTime() - new Date(start).getTime()) / (1000 * 60 * 60);
  const points = duration > 0 ? Math.round(duration * 43) : 0;

  return (
    <div className="bg-white text-black font-sans min-h-screen">
      {/* Gallery & Booking Section */}
      <section className="max-w-7xl mx-auto px-4 pt-10 grid md:grid-cols-1 gap-10">
        {/* Gallery */}
        <div>
          <div className="grid grid-cols-2 grid-rows-2 gap-6">
            <img
              src="/image 209.png"
              alt="Studio Gallery 1"
              className="col-span-1 row-span-2 rounded-xl object-cover w-full h-[440px] md:h-[700px]"
            />
            <img
              src="/image 210.png"
              alt="Studio Gallery 2"
              className="col-span-1 row-span-1 rounded-xl object-cover w-full h-[210px] md:h-[340px]"
            />
            <div className="relative col-span-1 row-span-1">
              <img
                src="/image 211.png"
                alt="Studio Gallery 3"
                className="rounded-xl object-cover w-full h-[210px] md:h-[340px]"
              />
              <button className="absolute right-4 bottom-4 bg-white text-black px-4 py-2 rounded shadow border font-medium">
                SHOW ALL PHOTOS
              </button>
            </div>
          </div>
        </div>
        {/* Booking Card */}
      </section>

      {/* Studio Info Section */}
     <section className="max-w-7xl mx-auto px-4 py-10 mt-12 flex flex-col md:flex-row gap-12 items-start">
        {/* Left: Info */}
        <div className="flex-1 min-w-0">
          <div className="flex flex-wrap gap-4 mb-8">
            <span className="px-6 py-2 rounded-full border text-lg font-medium">
              NOMADIC SATELLITE
            </span>
            <span className="px-6 py-2 rounded-full border text-lg font-medium">
              MUSIC STUDIO
            </span>
            <span className="px-6 py-2 rounded-full border text-lg font-medium">
              BALI, INDONESIA
            </span>
          </div>
          <h1 className="text-6xl font-black mb-6 leading-tight tracking-tight">
            PROFESSIONAL VIDEO
            <br />
            STUDIO FOR CREATIVES
          </h1>
          <div className="flex items-center gap-3 mb-4 text-gray-800 text-xl font-semibold">
            <svg
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 24 24"
              strokeWidth={1.5}
              stroke="currentColor"
              className="w-6 h-6"
            >
              <path
                strokeLinecap="round"
                strokeLinejoin="round"
                d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0z"
              />
              <path
                strokeLinecap="round"
                strokeLinejoin="round"
                d="M4.5 20.25a8.25 8.25 0 1115 0v.75a.75.75 0 01-.75.75H5.25a.75.75 0 01-.75-.75v-.75z"
              />
            </svg>
            <span>
              Jl. Raya Ubud No.88, Ubud, Kecamatan Ubud, Kabupaten Gianyar, Bali
              80571, Indonesia
            </span>
          </div>
          <p className="text-gray-700 mt-6 text-2xl leading-relaxed max-w-3xl">
            Bali is a city of innovation, culture, and creativity, and Nomadic
            Studios is proud to be at the heart of it. Our space here is
            designed to empower creators across disciplines, providing the
            tools, resources, and inspiration needed to take your work to the
            next level. Whether you're a local professional looking for a
            versatile studio or a traveling creator seeking a place to call your
            creative home, you'll find everything you need here.
          </p>
        </div>
        {/* Right: Booking Card */}
        <div className="flex-shrink-0 w-full md:w-[520px]">
          <div className="border rounded-xl p-8 shadow-md flex flex-col gap-6">
            <div>
              <label className="block text-lg font-medium mb-2 text-gray-700">
                START
              </label>
              <div className="flex items-center justify-between border-b pb-4">
                <span className="text-xl font-semibold">
                  AUG 21, 2025, 10:30 AM
                </span>
                <svg
                  className="w-6 h-6 text-gray-400"
                  fill="none"
                  stroke="currentColor"
                  viewBox="0 0 24 24"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M8 10h.01M12 10h.01M16 10h.01M9 16h6"
                  />
                </svg>
              </div>
            </div>
            <div>
              <label className="block text-lg font-medium mb-2 text-gray-700">
                END
              </label>
              <div className="flex items-center justify-between border-b pb-4">
                <span className="text-xl font-semibold">
                  AUG 21, 2025, 01:30 PM
                </span>
                <svg
                  className="w-6 h-6 text-gray-400"
                  fill="none"
                  stroke="currentColor"
                  viewBox="0 0 24 24"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M8 10h.01M12 10h.01M16 10h.01M9 16h6"
                  />
                </svg>
              </div>
            </div>
            <div className="py-4 text-gray-600 text-lg border-b">
              Your reservation: 3h &nbsp; &bull; &nbsp; From: 130 points
            </div>
            <button className="bg-black text-white py-5 rounded-md hover:bg-gray-800 transition font-bold text-xl flex items-center justify-center gap-2">
              BOOK NOW <span className="ml-2">&rarr;</span>
            </button>
          </div>
        </div>
      </section>

      {/* Crew Section */}
      <section className="max-w-7xl mx-auto px-6 py-12">
        <h2 className="text-3xl font-bold mb-6">OUR CREW</h2>
        <div className="flex flex-wrap gap-2 mb-8">
          <button className="px-5 py-2 rounded-full border font-medium text-sm bg-black text-white">
            ALL CREW
          </button>
          <button className="px-5 py-2 rounded-full border font-medium text-sm">
            AUDIO ENGINEER
          </button>
          <button className="px-5 py-2 rounded-full border font-medium text-sm">
            AUDIO TECHNICIAN
          </button>
          <button className="px-5 py-2 rounded-full border font-medium text-sm">
            MORE
          </button>
        </div>
        <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-8">
          {[1, 2, 3, 4, 5, 6].map((i) => (
            <div key={i}>
              <img
                src="./bw.png"
                alt="Crew"
                className="rounded-xl w-full h-64 object-cover mb-2"
              />
              <div className="text-lg font-semibold">NAME SURNAME</div>
              <div className="text-gray-500 text-sm">Profession</div>
            </div>
          ))}
        </div>
      </section>

      {/* Equipment Section */}
      <section className="max-w-7xl mx-auto px-6 py-12">
        <h2 className="text-5xl font-black mb-10 tracking-tight">EQUIPMENT</h2>
       <div className="border-2 border-black rounded-xl overflow-hidden mb-12">
  <div className="grid grid-cols-1 gap-0">
    <div className="flex items-center gap-6 border-b border-black p-3">
      <img
        src="/Frame 1000003571.png"
        alt="DJ Equipment"
        className="w-20 h-20 object-cover"
      />
      <span className="text-2xl font-medium tracking-tight">DJ EQUIPMENT</span>
    </div>
    <div className="flex items-center gap-6 border-b border-black p-3">
      <img
        src="/Frame 1000003571 (1).png"
        alt="Cameras"
        className="w-20 h-20 object-cover"
      />
      <span className="text-2xl font-medium tracking-tight">CAMERAS</span>
    </div>
    <div className="flex items-center gap-6 p-3">
      <img
        src="/Frame 1000003571 (2).png"
        alt="Light"
        className="w-20 h-20 object-cover"
      />
      <span className="text-2xl font-medium tracking-tight">LIGHT</span>
    </div>
  </div>
</div>
        {/* Info & Map */}
        <div className="grid md:grid-cols-4 gap-8 mb-8">
          <div>
            <h3 className="font-bold mb-2 text-gray-700">ADDRESS</h3>
            <p className="text-gray-600 text-lg">
              Jl. Raya Ubud No.88, Ubud, Kecamatan Ubud, Kabupaten Gianyar, Bali
              80571, Indonesia
            </p>
          </div>
          <div>
            <h3 className="font-bold mb-2 text-gray-700">OPENING HOURS</h3>
            <p className="text-gray-600 text-lg">6:00 AM - 11:00 PM</p>
          </div>
          <div>
            <h3 className="font-bold mb-2 text-gray-700">CONTACT</h3>
            <p className="text-gray-600 text-lg">
              +91 87896546378
              <br />
              balicreativehub@gmail.com
            </p>
          </div>
          <div>
            <h3 className="font-bold mb-2 text-gray-700">
              ADDITIONAL INFORMATION
            </h3>
            <p className="text-gray-600 text-lg">
              You can go to us by bus from...
            </p>
          </div>
        </div>
        <div className="w-full h-96 rounded-xl overflow-hidden border">
          <img src="/map.png" alt="Map" className="w-full h-full object-cover" />
        </div>
      </section>
    </div>
  );
}
