import type { MetaFunction } from "@remix-run/node";
import { WelcomeSection } from "~/components/pages/home/WelcomeSection/WelcomeSection";
import { StudioTypesSection } from "~/components/pages/home/StudioTypesSection/StudioTypesSection";
import { LocationsSection } from "~/components/pages/home/LocationsSection/LocationsSection";
import { PeopleSection } from "~/components/shared/PeopleSection";
import { EquipmentSection } from "~/components/pages/home/EquipmentSection";
import { EventsSection } from "~/components/pages/home/EventsSection";
import { SupportSection } from "~/components/pages/home/SupportSection";
import { MembershipSection } from "~/components/shared/MembershipSection";
import { PublicRoute } from "~/components/RouteProtection";

export const meta: MetaFunction = () => {
  return [
    { title: "Nomadics Studios - Your Creative Space Awaits" },
    {
      name: "description",
      content:
        "Connect creators with premium studio spaces, professional equipment, and a thriving creative community.",
    },
  ];
};

export default function Index() {
  return (
    <PublicRoute>
      <div className="relative">
        <WelcomeSection />
        <StudioTypesSection />
        <LocationsSection />
        <PeopleSection
          title="THE PEOPLE TO HELP YOU CREATE"
          buttonText="FIND YOUR CREATIVE SUPPORT"
          buttonHref="/people"
          eyebrow="OUR TEAM"
        />
        <EquipmentSection />
        <EventsSection />
        <SupportSection />
        <MembershipSection />
      </div>
    </PublicRoute>
  );
}
