import type { MetaFunction } from "@remix-run/node";
import { useNavigate } from "@remix-run/react";
import { useLanguage } from "~/hooks/useLanguage";
import { API_BASE_URL, IMAGE_BASE_URL } from "~/lib/api";
import { isAuthenticated } from "~/lib/api";

export const meta: MetaFunction = () => {
  return [
    { title: "Equipment | Nomadics" },
    { name: "description", content: "Professional equipment for rent" },
  ];
};
const HeroSection: React.FC = () => {
  const { t } = useLanguage();

  return (
    <section className="bg-black text-white min-h-screen relative">
      {/* Background Image */}
      <div className="absolute inset-0 bg-[#030303]" />
      <img
        src="https://dashboard.nomadicstudios.net/images/fe/equipment-sec-one.png"
        alt=""
        className="absolute inset-0 h-full w-full object-cover"
      />
      <div className="absolute inset-0 bg-black/50" />

      <div className="relative z-10 max-w-[1400px] mx-auto h-full min-h-screen flex flex-col justify-center px-4 sm:px-6 md:px-8 py-16">
        {/* Main Title */}
        <div className="mb-8 md:mb-12 2xl:mb-16">
          <h1 className="text-[32px] leading-[1.1] md:text-[56px] lg:text-heading-1 2xl:text-[80px] uppercase font-bold tracking-[-0.02em] text-left max-w-4xl">
            {t("equipment.hero.title")}
          </h1>
        </div>

        {/* Description text */}
        <div className="ml-auto max-w-xs sm:max-w-sm md:max-w-md lg:max-w-lg 2xl:max-w-xl">
          <p className="text-body-3 sm:text-body-2 md:text-body-2 lg:text-body-1 2xl:text-body-1 leading-relaxed text-gray-300 text-right">
            {t("equipment.hero.description")}
          </p>
        </div>
      </div>
    </section>
  );
};
const ConsistentGearSection: React.FC = () => {
  const { t } = useLanguage();
  const navigate = useNavigate();

  const handleBookStudio = () => {
    if (isAuthenticated()) {
      navigate("/home");
    } else {
      navigate("/login");
    }
  };

  return (
    <section className="bg-white py-20 px-4">
      <div className="max-w-[1400px] mx-auto">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <div className="order-2 lg:order-1">
            <h2 className="text-heading-3 md:text-heading-2 2xl:text-heading-2 font-bold text-black mb-6 !text-black">
              {t("equipment.consistentGear.title")}
            </h2>
            <p className="text-body-2 2xl:text-body-1 text-gray-700 mb-8 leading-relaxed !text-black">
              {t("equipment.consistentGear.description")}
            </p>
            <button
              onClick={handleBookStudio}
              className="inline-flex items-center px-8 py-3 bg-white border-2 border-black text-black font-semibold hover:bg-black hover:text-white transition-colors duration-300"
            >
              {t("equipment.bookStudio")}
              <span className="ml-2">→</span>
            </button>
          </div>

          <div className="order-1 lg:order-2">
            <div className="relative">
              <div className="bg-gray-900 rounded-lg overflow-hidden shadow-2xl">
                <img
                  src={`${IMAGE_BASE_URL}/images/fe/equipment-sec-two.png`}
                  alt={t("equipment.consistentGear.imageAlt")}
                  className="w-full h-full object-cover aspect-video"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};
const InterconnectedSection: React.FC = () => {
  const { t } = useLanguage();
  const navigate = useNavigate();

  const handleBookStudio = () => {
    if (isAuthenticated()) {
      navigate("/home");
    } else {
      navigate("/login");
    }
  };

  return (
    <section className="bg-gray-50 py-20 px-4">
      <div className="max-w-[1400px] mx-auto">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <div className="order-1">
            <div className="relative">
              <div className="bg-black rounded-lg overflow-hidden shadow-2xl">
                <img
                  src={`${IMAGE_BASE_URL}/images/fe/equipment-sec-three.png`}
                  alt={t("equipment.interconnected.imageAlt")}
                  className="w-full h-full object-cover aspect-video"
                />
              </div>
            </div>
          </div>

          <div className="order-2">
            <h2 className="text-heading-3 md:text-heading-2 2xl:text-heading-2 font-bold text-black mb-6 !text-black">
              {t("equipment.interconnected.title")}
            </h2>
            <p className="text-body-2 2xl:text-body-1 text-gray-700 mb-8 leading-relaxed !text-black">
              {t("equipment.interconnected.description")}
            </p>
            <button
              onClick={handleBookStudio}
              className="inline-flex items-center px-8 py-3 2xl:px-12 2xl:py-5 2xl:text-[22px] bg-white border-2 border-black text-black font-semibold hover:bg-black hover:text-white transition-colors duration-300"
            >
              {t("equipment.bookStudio")}
              <span className="ml-2">→</span>
            </button>
          </div>
        </div>
      </div>
    </section>
  );
};
const StockedEssentialsSection: React.FC = () => {
  const { t } = useLanguage();
  const navigate = useNavigate();

  const handleBookStudio = () => {
    if (isAuthenticated()) {
      navigate("/home");
    } else {
      navigate("/login");
    }
  };

  return (
    <section className="bg-white py-20 px-4">
      <div className="max-w-[1400px] mx-auto">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <div className="order-2 lg:order-1">
            <h2 className="text-heading-3 md:text-heading-2 2xl:text-heading-2 font-bold text-black mb-6 !text-black">
              {t("equipment.professionalGrade.title")}
            </h2>
            <p className="text-body-2 2xl:text-body-1 text-gray-700 mb-8 leading-relaxed !text-black">
              {t("equipment.professionalGrade.description")}
            </p>
            <button
              onClick={handleBookStudio}
              className="inline-flex items-center px-8 py-3 2xl:px-10 2xl:py-4 2xl:text-button-big bg-white border-2 border-black text-black font-semibold hover:bg-black hover:text-white transition-colors duration-300"
            >
              {t("equipment.bookStudio")}
              <span className="ml-2">→</span>
            </button>
          </div>

          <div className="order-1 lg:order-2">
            <div className="relative">
              <div className="bg-gray-900 rounded-lg overflow-hidden shadow-2xl">
                <img
                  src={`${IMAGE_BASE_URL}/images/fe/equipment-sec-four.png`}
                  alt={t("equipment.stockedEssentials.imageAlt")}
                  className="w-full h-full object-cover aspect-video"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};
const ExpertGuidanceSection: React.FC = () => {
  const { t } = useLanguage();
  const navigate = useNavigate();

  const handleBookStudio = () => {
    if (isAuthenticated()) {
      navigate("/home");
    } else {
      navigate("/login");
    }
  };

  return (
    <section className="bg-gray-50 py-20 px-4">
      <div className="max-w-7xl mx-auto">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <div className="order-1">
            <div className="relative">
              <div className="bg-black rounded-lg overflow-hidden shadow-2xl">
                <img
                  src={`${IMAGE_BASE_URL}/images/fe/equipment-sec-five.png`}
                  alt={t("equipment.expertGuidance.imageAlt")}
                  className="w-full h-full object-cover aspect-video"
                />
              </div>
            </div>
          </div>

          <div className="order-2">
            <h2 className="text-heading-3 md:text-heading-2 2xl:text-heading-2 font-bold text-black mb-6 !text-black">
              {t("equipment.expertGuidance.title")}
            </h2>
            <p className="text-body-2 2xl:text-body-1 text-gray-700 mb-8 leading-relaxed !text-black">
              {t("equipment.expertGuidance.description")}
            </p>
            <button
              onClick={handleBookStudio}
              className="inline-flex items-center px-8 py-3 2xl:px-12 2xl:py-5 2xl:text-[22px] bg-white border-2 border-black text-black font-semibold hover:bg-black hover:text-white transition-colors duration-300"
            >
              {t("equipment.bookStudio")}
              <span className="ml-2">→</span>
            </button>
          </div>
        </div>
      </div>
    </section>
  );
};
const SpecializedRentalsSection: React.FC = () => {
  const { t } = useLanguage();
  const navigate = useNavigate();

  const handleBookStudio = () => {
    if (isAuthenticated()) {
      navigate("/home");
    } else {
      navigate("/login");
    }
  };

  return (
    <section className="bg-white py-20 px-4">
      <div className="max-w-[1400px] mx-auto">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <div className="order-2 lg:order-1">
            <h2 className="text-heading-3 font-bold text-black mb-6 !text-black">
              {t("equipment.specializedRentals.title")}
            </h2>
            <p className="text-body-1 text-gray-700 mb-8 leading-relaxed !text-black">
              {t("equipment.specializedRentals.description")}
            </p>
            <button
              onClick={handleBookStudio}
              className="inline-flex items-center px-8 py-3 bg-white border-2 border-black text-black font-semibold hover:bg-black hover:text-white transition-colors duration-300"
            >
              {t("equipment.bookStudio")}
              <span className="ml-2">→</span>
            </button>
          </div>

          <div className="order-1 lg:order-2">
            <div className="relative">
              <div className="bg-gray-900 rounded-lg overflow-hidden shadow-2xl">
                <img
                  src={`${IMAGE_BASE_URL}/images/fe/equipment-sec-six.png`}
                  alt={t("equipment.specializedRentals.imageAlt")}
                  className="w-full h-full object-cover aspect-video"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};
const ConnectCollaborateSection: React.FC = () => {
  const { t } = useLanguage();
  const navigate = useNavigate();

  const handleApplyMembership = () => {
    if (isAuthenticated()) {
      navigate("/account-settings?tab=membership");
    } else {
      navigate("/signup");
    }
  };

  return (
    <section className="bg-black text-white py-32 px-4">
      <div className="max-w-4xl mx-auto text-center">
        <div className="mb-16">
          <h2 className="text-3xl md:text-7xl font-black leading-tight mb-8">
            {t("equipment.connectCollaborate.title")}
          </h2>
          <p className="text-xl md:text-2xl text-gray-300 leading-relaxed max-w-3xl mx-auto">
            {t("equipment.connectCollaborate.description")}
          </p>
        </div>

        <div className="mt-12">
          <button
            onClick={handleApplyMembership}
            className="inline-flex items-center px-12 py-4 bg-white text-black font-bold text-lg hover:bg-gray-100 transition-colors duration-300"
          >
            {t("equipment.applyForMembership")}
            <span className="ml-3">→</span>
          </button>
        </div>

        {/* Footer spacing */}
        {/* <div className="mt-24 pt-12 border-t border-gray-800"> */}
          {/* <p className="text-gray-500 text-sm">{t("equipment.copyright")}</p> */}
        {/* </div> */}
      </div>
    </section>
  );
};
export default function Equipment() {
  return (
    <>
      <HeroSection />
      <ConsistentGearSection />
      <InterconnectedSection />
      <StockedEssentialsSection />
      <ExpertGuidanceSection />
      <SpecializedRentalsSection />
      <ConnectCollaborateSection />
    </>
  );
}
