import React from "react";
import { useNavigate } from "@remix-run/react";
import { API_BASE_URL, IMAGE_BASE_URL, isAuthenticated } from "~/lib/api";
import { useLanguage } from "~/hooks/useLanguage";

export default function services() {
  const { t } = useLanguage();
  const navigate = useNavigate();

  const handleApplyMembership = () => {
    navigate("/account-settings");
  };

  const servicesData = [
    {
      title: t("services.items.socialMedia.title", "SOCIAL MEDIA STRATEGY"),
      description: t(
        "services.items.socialMedia.description",
        "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality."
      ),
      image: `${IMAGE_BASE_URL}/images/fe/services-sec-two.png`,
      reverse: false,
    },
    {
      title: t(
        "services.items.contentCreation.title",
        "CONTENT CREATION (IMAGES, VIDEOS, COPY)"
      ),
      description: t(
        "services.items.contentCreation.description",
        "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality."
      ),
      image: `${IMAGE_BASE_URL}/images/fe/services-sec-three.png`,
      reverse: true,
    },
    {
      title: t("services.items.paidAds.title", "PAID AD CAMPAIGNS"),
      description: t(
        "services.items.paidAds.description",
        "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality."
      ),
      image: `${IMAGE_BASE_URL}/images/fe/services-sec-four.png`,
      reverse: false,
    },
    {
      title: t("services.items.analytics.title", "ANALYTICS AND INSIGHTS"),
      description: t(
        "services.items.analytics.description",
        "Whether you're filming a commercial, live-streaming a podcast, or editing a short film, our studios provide the space and tools you need to deliver professional results. Unlike other generic rental spaces, we're built specifically for creators who demand both flexibility and quality."
      ),
      image: `${IMAGE_BASE_URL}/images/fe/services-sec-five.png`,
      reverse: true,
    },
  ];

  return (
    <div className="bg-black text-white min-h-screen font-sans">
      {/* Hero Section */}
      <section className="relative min-h-screen">
        {/* Background Image */}
        <div className="absolute inset-0 bg-[#030303]" />
        <img
          src="https://dashboard.nomadicstudios.net/images/fe/services-sec-one.png"
          alt=""
          className="absolute inset-0 h-full w-full object-cover"
        />
        <div className="absolute inset-0 bg-black/50" />

        <div className="relative z-10 max-w-[1400px] mx-auto px-4 sm:px-6 lg:px-8 py-20 min-h-screen flex flex-col justify-center">
          <h1 className="text-[32px] leading-[1.1] md:text-[56px] lg:text-heading-1 2xl:text-[80px] uppercase mb-6 sm:mb-8 font-bold tracking-[-0.02em] max-w-4xl mx-auto">
            {t("services.hero.title", "GROW YOUR AUDIENCE, BUILD YOUR BRAND.")}
          </h1>
          <div className="flex flex-col md:flex-row md:items-center gap-6 sm:gap-8 mb-12 sm:mb-16">
            <div className="md:w-1/2"></div>
            <div className="md:w-1/2 text-body-3 md:text-body-2 2xl:text-body-1 text-gray-200">
              {t(
                "services.hero.description",
                "Our team offers a complete suite of social media and marketing services, including content creation, post-scheduling, analytics, and campaign management. Whether you're an emerging artist or a seasoned professional, we help you stand out in a crowded digital landscape."
              )}
            </div>
          </div>
          <div className="flex flex-col sm:flex-row gap-3 sm:gap-4 md:gap-6 justify-center mb-12 sm:mb-16">
            <button className="border border-white rounded-full px-6 sm:px-8 md:px-10 py-4 sm:py-5 md:py-6 2xl:px-12 2xl:py-6 text-button-small sm:text-button-medium md:text-button-big 2xl:text-button-big font-medium text-white hover:bg-white hover:text-black transition w-full sm:w-auto">"
              {t("services.hero.expandReach", "EXPAND YOUR REACH")}
            </button>
            <button className="border border-white rounded-full px-6 sm:px-8 md:px-10 py-4 sm:py-5 md:py-6 2xl:px-12 2xl:py-6 text-button-small sm:text-button-medium md:text-button-big 2xl:text-button-big font-medium text-white hover:bg-white hover:text-black transition w-full sm:w-auto">
              {t("services.hero.generateIncome", "GENERATE PASSIVE INCOME")}
            </button>
            <button className="border border-white rounded-full px-6 sm:px-8 md:px-10 py-4 sm:py-5 md:py-6 2xl:px-12 2xl:py-6 text-button-small sm:text-button-medium md:text-button-big 2xl:text-button-big font-medium text-white hover:bg-white hover:text-black transition w-full sm:w-auto">
              {t("services.hero.simplifyMonetization", "SIMPLIFY MONETIZATION")}
            </button>
          </div>
        </div>
      </section>

      {/* Service Sections */}
      <div className="bg-white text-black py-12 sm:py-16 md:py-20">
        <div className="max-w-[1400px] mx-auto">
          {servicesData.map((service, idx) => (
            <div
              key={service.title}
              className={`grid md:grid-cols-2 gap-0 items-stretch`}
            >
              {/* Alternate image/text position for each row */}
              {idx % 2 === 0 ? (
                <>
                  <div className="flex items-center justify-center p-4 sm:p-6 md:p-8">
                    <img
                      src={service.image}
                      alt={service.title}
                      className="rounded-xl w-full h-48 sm:h-56 md:h-64 object-cover shadow-lg"
                    />
                  </div>
                  <div className="flex flex-col justify-center p-4 sm:p-6 md:p-8">
                    <h2 className="text-heading-4 sm:text-heading-3 2xl:text-heading-2 font-bold mb-3 sm:mb-4 !text-black">
                      {service.title}
                    </h2>
                    <p className="text-body-3 sm:text-body-2 2xl:text-body-1 text-gray-700 leading-relaxed !text-black">
                      {service.description}
                    </p>
                  </div>
                </>
              ) : (
                <>
                  <div className="flex flex-col justify-center p-4 sm:p-6 md:p-8">
                    <h2 className="text-heading-4 sm:text-heading-3 2xl:text-heading-2 font-bold mb-3 sm:mb-4 !text-black">
                      {service.title}
                    </h2>
                    <p className="text-body-3 sm:text-body-2 2xl:text-body-1 text-gray-700 leading-relaxed !text-black">
                      {service.description}
                    </p>
                  </div>
                  <div className="flex items-center justify-center p-4 sm:p-6 md:p-8">
                    <img
                      src={service.image}
                      alt={service.title}
                      className="rounded-xl w-full h-48 sm:h-56 md:h-64 object-cover shadow-lg"
                    />
                  </div>
                </>
              )}
            </div>
          ))}
        </div>
      </div>

      {/* CTA Section */}
      <section className="bg-black text-white py-12 sm:py-16 md:py-24 text-center px-4 sm:px-6">
        <div className="max-w-[1200px] mx-auto">
        <h2 className="text-heading-3 sm:text-heading-2 md:text-heading-1 lg:text-heading-1 2xl:text-heading-1 font-black mb-6 sm:mb-8">
          {t(
            "services.cta.title",
            "JOIN US TO LEARN HOW TO GET STARTED WITH ONLINE SERVICES."
          )}
        </h2>
        <p className="text-body-3 sm:text-body-2 2xl:text-body-1 text-gray-200 mb-6 sm:mb-8 max-w-2xl 2xl:max-w-3xl mx-auto">
          {t(
            "services.cta.description",
            "Be part of something bigger. Nomadic Studios is more than just a place to work – it's a vibrant network of creatives who inspire and support each other."
          )}
        </p>
        <button
          onClick={handleApplyMembership}
          className="bg-white text-black font-semibold px-10 py-5 2xl:px-12 2xl:py-6 2xl:text-button-big rounded shadow hover:bg-gray-200 transition text-lg"
        >
          {t("services.cta.button", "APPLY FOR MEMBERSHIP")} &rarr;
        </button>
        </div>
      </section>
    </div>
  );
}
