import type { MetaFunction } from "@remix-run/node";
import { AppHeader } from "~/components/AppHeader";
import { AppFooter } from "~/components/AppFooter";

export const meta: MetaFunction = () => {
  return [
    { title: "Terms & Conditions - Nomadic Studios" },
    {
      name: "description",
      content:
        "Read our terms and conditions for using Nomadic Studios services and facilities.",
    },
  ];
};

export default function Terms() {
  return (
    <div className="min-h-screen bg-black">
      <AppHeader theme="dark" />

      <main className="pt-20">
        <section className="relative w-full bg-black">
          <div className="container max-w-[1400px] mx-auto py-14 lg:py-[120px]">
            <div className="text-center">
              <h1 className="text-4xl md:text-6xl font-light tracking-wider text-white mb-8">
                Terms & Conditions
              </h1>
              <p className="text-lg text-white/70 max-w-2xl mx-auto">
                This page is currently under construction. Please check back
                soon for our complete terms and conditions.
              </p>
            </div>
          </div>
        </section>
      </main>
    </div>
  );
}
