import {
  authAPI
} from "./build/_shared/chunk-4X4B3Y7G.js";
import {
  Button
} from "./build/_shared/chunk-XQGTNQYO.js";
import {
  useLocation,
  useNavigate
} from "./build/_shared/chunk-5EQN7Y3V.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/components/auth/UploadProfilePicture.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\auth\\\\UploadProfilePicture.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\auth\\UploadProfilePicture.tsx"
  );
  import.meta.hot.lastModified = "1760464886205.697";
}
var UploadProfilePicture = () => {
  _s();
  const navigate = useNavigate();
  const location = useLocation();
  const fileInputRef = (0, import_react.useRef)(null);
  const [isVisible, setIsVisible] = (0, import_react.useState)(false);
  const [isLoading, setIsLoading] = (0, import_react.useState)(false);
  const [error, setError] = (0, import_react.useState)(null);
  const [selectedImage, setSelectedImage] = (0, import_react.useState)(null);
  const [imageFile, setImageFile] = (0, import_react.useState)(null);
  const uuid = location.state?.uuid;
  const userData = location.state?.userData;
  (0, import_react.useEffect)(() => {
    if (!uuid) {
      navigate("/signup");
      return;
    }
    setIsVisible(true);
  }, [uuid, navigate]);
  const handleImageSelect = (e) => {
    const file = e.target.files?.[0];
    if (!file)
      return;
    if (!file.type.startsWith("image/")) {
      setError("Please select a valid image file");
      return;
    }
    if (file.size > 5 * 1024 * 1024) {
      setError("Image size should be less than 5MB");
      return;
    }
    setImageFile(file);
    setError(null);
    const reader = new FileReader();
    reader.onload = (e2) => {
      setSelectedImage(e2.target?.result);
    };
    reader.readAsDataURL(file);
  };
  const handleUpload = async () => {
    if (!imageFile || !uuid)
      return;
    setIsLoading(true);
    setError(null);
    try {
      const reader = new FileReader();
      reader.onload = async (e) => {
        const base64Image = e.target?.result;
        try {
          const response = await authAPI.saveProfilePicture(uuid, base64Image);
          if (response.status) {
            navigate("/additional-information", {
              state: {
                uuid,
                userData
              }
            });
          } else {
            setError(response.error || "Failed to upload profile picture. Please try again.");
          }
        } catch (err) {
          console.error("Profile picture upload error:", err);
          setError(err instanceof Error ? err.message : "An unexpected error occurred. Please try again.");
        } finally {
          setIsLoading(false);
        }
      };
      reader.readAsDataURL(imageFile);
    } catch (err) {
      console.error("File processing error:", err);
      setError("Failed to process image. Please try again.");
      setIsLoading(false);
    }
  };
  const handleSkip = () => {
    navigate("/additional-information", {
      state: {
        uuid,
        userData
      }
    });
  };
  const formatTime = (seconds) => {
    const mins = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return `${mins}:${secs.toString().padStart(2, "0")}`;
  };
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "min-h-screen bg-[#030303] relative overflow-hidden", children: [
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: "/images/home/welcome.png", alt: "", className: "absolute inset-0 h-full w-full object-cover opacity-40" }, void 0, false, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 126,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 bg-gradient-to-br from-[#030303]/80 via-[#030303]/60 to-[#030303]/80" }, void 0, false, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 127,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/UploadProfilePicture.tsx",
      lineNumber: 125,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute inset-0 overflow-hidden pointer-events-none", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-20 left-10 w-2 h-2 bg-orange-400 rounded-full animate-bounce opacity-60", style: {
        animationDelay: "0s",
        animationDuration: "3s"
      } }, void 0, false, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 132,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute top-40 right-16 w-1 h-1 bg-white rounded-full animate-pulse opacity-40", style: {
        animationDelay: "1s"
      } }, void 0, false, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 136,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-32 left-20 w-3 h-3 border border-orange-400 rounded-full animate-ping opacity-30", style: {
        animationDelay: "2s"
      } }, void 0, false, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 139,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "absolute bottom-20 right-10 w-2 h-2 bg-white rounded-full animate-bounce opacity-50", style: {
        animationDelay: "1.5s",
        animationDuration: "4s"
      } }, void 0, false, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 142,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/UploadProfilePicture.tsx",
      lineNumber: 131,
      columnNumber: 7
    }, this),
    /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative z-10 min-h-screen flex flex-col items-center justify-center px-4 lg:px-0", children: [
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `text-center mb-12 transform transition-all duration-1000 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h1", { className: "text-4xl lg:text-6xl font-bold text-white uppercase tracking-tight mb-4", children: "ADD PROFILE PICTURE" }, void 0, false, {
          fileName: "app/components/auth/UploadProfilePicture.tsx",
          lineNumber: 152,
          columnNumber: 11
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { className: "text-lg lg:text-xl text-white/80 font-light", children: "Let's make your profile shine" }, void 0, false, {
          fileName: "app/components/auth/UploadProfilePicture.tsx",
          lineNumber: 155,
          columnNumber: 11
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 151,
        columnNumber: 9
      }, this),
      /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: `w-full max-w-md transform transition-all duration-1000 delay-300 ${isVisible ? "translate-y-0 opacity-100" : "translate-y-10 opacity-0"}`, children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 shadow-2xl", children: [
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("h2", { className: "text-2xl font-semibold mb-8 text-white text-center uppercase tracking-wider", children: "Profile Picture" }, void 0, false, {
          fileName: "app/components/auth/UploadProfilePicture.tsx",
          lineNumber: 163,
          columnNumber: 13
        }, this),
        error && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-6 p-4 bg-red-500/20 border border-red-500/30 text-red-200 rounded-xl text-sm backdrop-blur-sm", children: error }, void 0, false, {
          fileName: "app/components/auth/UploadProfilePicture.tsx",
          lineNumber: 168,
          columnNumber: 23
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "mb-8 text-center", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "relative inline-block", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "w-32 h-32 mx-auto rounded-full overflow-hidden border-4 border-white/20 bg-white/10 flex items-center justify-center", children: selectedImage ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("img", { src: selectedImage, alt: "Profile preview", className: "w-full h-full object-cover" }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 176,
            columnNumber: 36
          }, this) : /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-16 h-16 text-white/40", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 177,
            columnNumber: 23
          }, this) }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 176,
            columnNumber: 127
          }, this) }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 175,
            columnNumber: 17
          }, this),
          selectedImage && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("button", { onClick: () => {
            setSelectedImage(null);
            setImageFile(null);
            if (fileInputRef.current) {
              fileInputRef.current.value = "";
            }
          }, className: "absolute -top-2 -right-2 bg-red-500 hover:bg-red-600 text-white rounded-full p-2 transition-colors", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-4 h-4", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M6 18L18 6M6 6l12 12" }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 189,
            columnNumber: 23
          }, this) }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 188,
            columnNumber: 21
          }, this) }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 181,
            columnNumber: 35
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/UploadProfilePicture.tsx",
          lineNumber: 174,
          columnNumber: 15
        }, this) }, void 0, false, {
          fileName: "app/components/auth/UploadProfilePicture.tsx",
          lineNumber: 173,
          columnNumber: 13
        }, this),
        /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "space-y-6", children: [
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("input", { ref: fileInputRef, type: "file", accept: "image/*", onChange: handleImageSelect, className: "hidden", disabled: isLoading }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 198,
            columnNumber: 15
          }, this),
          !selectedImage && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "lg", className: "w-full", onClick: () => fileInputRef.current?.click(), disabled: isLoading, children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("svg", { className: "w-5 h-5 mr-3", fill: "none", stroke: "currentColor", viewBox: "0 0 24 24", children: /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("path", { strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 2, d: "M12 6v6m0 0v6m0-6h6m-6 0H6" }, void 0, false, {
              fileName: "app/components/auth/UploadProfilePicture.tsx",
              lineNumber: 203,
              columnNumber: 21
            }, this) }, void 0, false, {
              fileName: "app/components/auth/UploadProfilePicture.tsx",
              lineNumber: 202,
              columnNumber: 19
            }, this),
            "Choose Image"
          ] }, void 0, true, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 201,
            columnNumber: 34
          }, this),
          selectedImage && /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "fill-white", size: "lg", className: "w-full", onClick: handleUpload, disabled: isLoading, arrowRight: !isLoading, children: isLoading ? /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "animate-spin rounded-full h-5 w-5 border-b-2 border-black mr-3" }, void 0, false, {
              fileName: "app/components/auth/UploadProfilePicture.tsx",
              lineNumber: 211,
              columnNumber: 23
            }, this),
            "Uploading..."
          ] }, void 0, true, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 210,
            columnNumber: 32
          }, this) : "Upload & Continue" }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 209,
            columnNumber: 33
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(Button, { type: "button", variant: "outline-white", size: "md", className: "w-full", onClick: handleSkip, disabled: isLoading, children: "Skip for now" }, void 0, false, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 217,
            columnNumber: 15
          }, this),
          /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("div", { className: "text-center text-white/60 text-xs space-y-1", children: [
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { children: "Accepted formats: JPG, PNG, GIF" }, void 0, false, {
              fileName: "app/components/auth/UploadProfilePicture.tsx",
              lineNumber: 223,
              columnNumber: 17
            }, this),
            /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)("p", { children: "Maximum file size: 5MB" }, void 0, false, {
              fileName: "app/components/auth/UploadProfilePicture.tsx",
              lineNumber: 224,
              columnNumber: 17
            }, this)
          ] }, void 0, true, {
            fileName: "app/components/auth/UploadProfilePicture.tsx",
            lineNumber: 222,
            columnNumber: 15
          }, this)
        ] }, void 0, true, {
          fileName: "app/components/auth/UploadProfilePicture.tsx",
          lineNumber: 196,
          columnNumber: 13
        }, this)
      ] }, void 0, true, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 162,
        columnNumber: 11
      }, this) }, void 0, false, {
        fileName: "app/components/auth/UploadProfilePicture.tsx",
        lineNumber: 161,
        columnNumber: 9
      }, this)
    ] }, void 0, true, {
      fileName: "app/components/auth/UploadProfilePicture.tsx",
      lineNumber: 149,
      columnNumber: 7
    }, this)
  ] }, void 0, true, {
    fileName: "app/components/auth/UploadProfilePicture.tsx",
    lineNumber: 123,
    columnNumber: 10
  }, this);
};
_s(UploadProfilePicture, "We2CM5BliQ4StjORIW8aoqwWI7I=", false, function() {
  return [useNavigate, useLocation];
});
_c = UploadProfilePicture;
var UploadProfilePicture_default = UploadProfilePicture;
var _c;
$RefreshReg$(_c, "UploadProfilePicture");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

export {
  UploadProfilePicture_default
};
//# sourceMappingURL=build/_shared/chunk-TIRQDB7S.js.map
