import {
  isAuthenticated
} from "./build/_shared/chunk-4X4B3Y7G.js";
import {
  useLocation,
  useNavigate
} from "./build/_shared/chunk-5EQN7Y3V.js";
import {
  createHotContext
} from "./build/_shared/chunk-EVUEESPC.js";
import {
  require_jsx_dev_runtime
} from "./build/_shared/chunk-I56M6IG2.js";
import {
  require_react
} from "./build/_shared/chunk-DN24R6NH.js";
import {
  __toESM
} from "./build/_shared/chunk-KX7HMTBE.js";

// app/components/RouteProtection.tsx
var import_react = __toESM(require_react(), 1);
var import_jsx_dev_runtime = __toESM(require_jsx_dev_runtime(), 1);
if (!window.$RefreshReg$ || !window.$RefreshSig$ || !window.$RefreshRuntime$) {
  console.warn("remix:hmr: React Fast Refresh only works when the Remix compiler is running in development mode.");
} else {
  prevRefreshReg = window.$RefreshReg$;
  prevRefreshSig = window.$RefreshSig$;
  window.$RefreshReg$ = (type, id) => {
    window.$RefreshRuntime$.register(type, '"app\\\\components\\\\RouteProtection.tsx"' + id);
  };
  window.$RefreshSig$ = window.$RefreshRuntime$.createSignatureFunctionForTransform;
}
var prevRefreshReg;
var prevRefreshSig;
var _s = $RefreshSig$();
if (import.meta) {
  import.meta.hot = createHotContext(
    //@ts-expect-error
    "app\\components\\RouteProtection.tsx"
  );
  import.meta.hot.lastModified = "1759761980430.1548";
}
function RouteProtection({
  children,
  requireAuth = true
}) {
  _s();
  const navigate = useNavigate();
  const location = useLocation();
  (0, import_react.useEffect)(() => {
    const checkAndRedirect = () => {
      const authenticated2 = isAuthenticated();
      if (requireAuth && !authenticated2) {
        navigate("/login");
      } else if (!requireAuth && authenticated2) {
        navigate("/home");
      }
    };
    checkAndRedirect();
    const timeout = setTimeout(checkAndRedirect, 100);
    return () => clearTimeout(timeout);
  }, [requireAuth, navigate, location.pathname]);
  const authenticated = isAuthenticated();
  if (requireAuth && !authenticated) {
    return null;
  }
  if (!requireAuth && authenticated) {
    return null;
  }
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(import_jsx_dev_runtime.Fragment, { children }, void 0, false, {
    fileName: "app/components/RouteProtection.tsx",
    lineNumber: 61,
    columnNumber: 10
  }, this);
}
_s(RouteProtection, "gMsdikdDs1f1NUVrv3Ag60oK04k=", false, function() {
  return [useNavigate, useLocation];
});
_c = RouteProtection;
function ProtectedRoute({
  children
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(RouteProtection, { requireAuth: true, children }, void 0, false, {
    fileName: "app/components/RouteProtection.tsx",
    lineNumber: 72,
    columnNumber: 10
  }, this);
}
_c2 = ProtectedRoute;
function PublicRoute({
  children
}) {
  return /* @__PURE__ */ (0, import_jsx_dev_runtime.jsxDEV)(RouteProtection, { requireAuth: false, children }, void 0, false, {
    fileName: "app/components/RouteProtection.tsx",
    lineNumber: 80,
    columnNumber: 10
  }, this);
}
_c3 = PublicRoute;
var _c;
var _c2;
var _c3;
$RefreshReg$(_c, "RouteProtection");
$RefreshReg$(_c2, "ProtectedRoute");
$RefreshReg$(_c3, "PublicRoute");
window.$RefreshReg$ = prevRefreshReg;
window.$RefreshSig$ = prevRefreshSig;

export {
  ProtectedRoute,
  PublicRoute
};
//# sourceMappingURL=build/_shared/chunk-MYKE2GOT.js.map
